/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.networksource;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.networksource.NetworkSourceGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.NetworkSpectrometer;

public class NetworkSourceImpl
extends USBFeature
implements NetworkSourceGUIProvider {
    private NetworkSpectrometer spectrometer = null;
    private String sourceAddress = null;
    private int sourcePort = 0;
    protected String featurePath = "networksource.NetworkSourcePanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/NetworkSpectrometer;)V\nconnectToSource,(Ljava/lang/String;I)V\nisConnected,()Z\ngetFeatureGUIClassnames,()[Ljava/lang/String;\ndisconnect,()V\nreconnect,()V\ngetAddress,()Ljava/lang/String;\ngetPort,()I\n";

    public NetworkSourceImpl(USBInterface usb, NetworkSpectrometer spec) {
        super(usb);
        this.spectrometer = spec;
        this.sourceAddress = this.spectrometer.getAddress();
        this.sourcePort = this.spectrometer.getPort();
        this.panelPath = "com.oceanoptics.omnidriver.guisupport.features";
    }

    public void connectToSource(String address, int port) {
        this.sourceAddress = new String(address);
        this.sourcePort = port;
        this.spectrometer.connectToSource(address, port);
        this.isConnected();
    }

    public boolean isConnected() {
        return this.spectrometer.isConnected();
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    public void disconnect() {
        this.spectrometer.disconnect();
    }

    public void reconnect() throws IllegalStateException {
        if (null == this.sourceAddress) {
            throw new IllegalStateException("Cannot reconnect if never previously told to connectToSource");
        }
        this.disconnect();
        this.connectToSource(this.sourceAddress, this.sourcePort);
    }

    public String getAddress() {
        return this.sourceAddress;
    }

    public int getPort() {
        return this.sourcePort;
    }
}

