/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.pluginprovider;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;

public abstract class PlugInProviderImpl
extends USBFeature
implements PlugInProvider {
    private static final int MAX_PLUGINS = 6;
    private Spectrometer spectrometer;
    public USBEndpointDescriptor dataOutEndPoint = null;
    public USBEndpointDescriptor lowSpeedInEndPoint = null;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\ndetectPlugIns,()V\ngetNumberOfPlugIns,()I\ninitializePlugIns,()[B\nisPlugInDetected,(I)Z\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\n";
    static /* synthetic */ Class class$com$oceanoptics$omnidriver$spectrometer$USBSpectrometer;
    static /* synthetic */ Class class$com$oceanoptics$omnidriver$interfaces$USBInterface;

    public PlugInProviderImpl(USBInterface usbInt, Spectrometer spec) {
        super(usbInt);
        this.spectrometer = spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectPlugIns() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.logger.fine("Detecting plugins...");
            this.out[0] = 13;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPlugIns() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int numPlugIns = -1;
                this.out[0] = 11;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 1);
                numPlugIns = this.in[0];
                this.logger.fine("Number of plugins: " + (numPlugIns - 1));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return numPlugIns - 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] initializePlugIns() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] b = new byte[7];
                byte[] result = new byte[6];
                this.out[0] = 12;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, b, 7);
                for (int i = 0; i < 6; ++i) {
                    result[i] = b[i];
                }
                this.logger.fine("Plugins initialized.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }
    }

    public boolean isPlugInDetected(int id) throws IOException {
        byte[] plugIns = this.initializePlugIns();
        for (int i = 0; i < 6; ++i) {
            if (plugIns[i] != id) continue;
            this.logger.fine("Plugin detected.");
            return true;
        }
        return false;
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        this.logger.finest("In readPlugIns()");
        SpectrometerPlugIn[] plugIns = new SpectrometerPlugIn[6];
        int numFound = 0;
        byte[] ids = this.initializePlugIns();
        for (int i = 0; i < 6; ++i) {
            if (ids[i] == 0) continue;
            String className = SpectrometerPlugIn.getClassName(ids[i]);
            try {
                Class[] argTypes = new Class[]{class$com$oceanoptics$omnidriver$spectrometer$USBSpectrometer == null ? PlugInProviderImpl.class$("com.oceanoptics.omnidriver.spectrometer.USBSpectrometer") : class$com$oceanoptics$omnidriver$spectrometer$USBSpectrometer, class$com$oceanoptics$omnidriver$interfaces$USBInterface == null ? PlugInProviderImpl.class$("com.oceanoptics.omnidriver.interfaces.USBInterface") : class$com$oceanoptics$omnidriver$interfaces$USBInterface};
                Class<?> c = Class.forName(className);
                Constructor<?> constructor = c.getConstructor(argTypes);
                plugIns[numFound] = (SpectrometerPlugIn)constructor.newInstance(this.spectrometer, this.usb);
                ++numFound;
                continue;
            }
            catch (Exception e) {
                this.logger.severe("Detect plugins: Couldn't find the right class, or classloader/security problem.");
                e.printStackTrace();
                return null;
            }
        }
        SpectrometerPlugIn[] result = new SpectrometerPlugIn[numFound];
        for (int i = 0; i < numFound; ++i) {
            this.logger.fine("Plugin detected.");
            result[i] = plugIns[i];
        }
        return result;
    }
}

