/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.thermoelectric;

import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ThermoElectricImpl_NIR
extends ThermoElectricImpl {
    private Boolean tecEnabled = null;
    private Boolean fanEnabled = null;
    private Double setPoint = null;
    private final double SETPOINT_MIN_DEGREES_C = -40.0;
    private final double SETPOINT_MAX_DEGREES_C = 40.0;
    private final double SETPOINT_INCREMENT = 0.1;
    private final int COUNTS_PER_DEGREE_C = 10;
    protected boolean saveTECStateEnabled = false;
    protected String featurePath = "thermoelectric.ThermoElectricPanel";
    private static final short DATA_OUT = 2;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetFanEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\nsetTECEnable,(Z)V\ngetTECEnable,()Ljava/lang/Boolean;\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\nsetDetectorSetPointCelsius,(D)V\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ThermoElectricImpl_NIR(USBInterface usbInt) throws IOException {
        super(usbInt);
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = -2;
                byte[] sb = new byte[16];
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, sb, 16);
                this.tecEnabled = new Boolean((sb[13] & 1) != 0);
                this.fanEnabled = new Boolean((sb[13] & 2) != 0);
                int[] tecState = this.getTECInfo();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFanEnable(boolean enable) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int byteOn = enable ? 1 : 0;
            this.out[0] = 13;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("Fan set to (0:Off, 1:On): " + byteOn);
            this.fanEnabled = new Boolean(enable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Boolean getFanEnable() {
        return this.fanEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTECEnable(boolean enable) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int byteOn = enable ? 1 : 0;
            this.out[0] = 11;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("TEC controller set to (0:Disabled, 1:Enabled): " + byteOn);
            this.tecEnabled = new Boolean(enable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Boolean getTECEnable() {
        return this.tecEnabled;
    }

    public double getDetectorTemperatureCelsius() throws IOException {
        int[] tecStatus = this.getTECInfo();
        return this.countsToDegreesCelsius(tecStatus[0]);
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetectorSetPointCelsius(double tempCelsius) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            short temp = (short)(tempCelsius * 10.0);
            this.out[0] = 62;
            this.out[1] = 0;
            this.out[2] = ByteRoutines.getHighByte((short)temp);
            this.out[3] = ByteRoutines.getLowByte((short)temp);
            this.out[4] = 0;
            this.out[5] = 0;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 6);
            this.logger.fine("Detector's set-point temperature set to " + temp);
            this.setPoint = new Double(temp);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public Double getDetectorSetPointCelsius() {
        return this.setPoint;
    }

    public double getSetPointMinimumCelsius() {
        return -40.0;
    }

    public double getSetPointMaximumCelsius() {
        return 40.0;
    }

    public double getSetPointIncrementCelsius() {
        return 0.1;
    }

    private double countsToDegreesCelsius(int counts) {
        return (double)counts / 10.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getTECInfo() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 63;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 14);
                int[] detector = new int[]{ByteRoutines.makeWord((byte)this.in[4], (byte)this.in[5]), ByteRoutines.makeWord((byte)this.in[8], (byte)this.in[9])};
                this.logger.fine("Detector temperature: " + detector[0] + " ; Detector set-point: " + detector[1]);
                this.setPoint = new Double((double)detector[1] / 10.0);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return detector;
            }
        }
    }

    public boolean isSaveTECStateEnabled() {
        return this.saveTECStateEnabled;
    }

    public void saveTECState() throws IOException {
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

