/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.version;

import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersionImpl;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class VersionImpl
extends AdvancedVersionImpl
implements VersionGUIProvider {
    protected String featurePath = "version.VersionPanel";
    private Spectrometer spectrometer;
    protected transient ArrayList acquisitionListenerList;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\nisAdvancedVersion,()Z\ngetFirmwareVersion,()Ljava/lang/String;\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public VersionImpl(USBInterface usbInt, Spectrometer spectrometer) {
        super(usbInt);
        this.spectrometer = spectrometer;
    }

    public boolean isAdvancedVersion() {
        return this.spectrometer instanceof AdvancedVersion;
    }

    public String getFirmwareVersion() throws IOException {
        return this.spectrometer.getFirmwareVersion();
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.fireAcquisitionListenerPauseSpectrometerAcquisitions(this.spectrometer);
        System.out.println("Uploading firmware. Please wait...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.fireAcquisitionListenerResumeSpectrometerAcquisitions(this.spectrometer);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.fireAcquisitionListenerPauseSpectrometerAcquisitions(this.spectrometer);
        System.out.println("Uploading FPGA. Please wait...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.fireAcquisitionListenerResumeSpectrometerAcquisitions(this.spectrometer);
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    public synchronized void addAcquisitionListener(AcquisitionListener listener) {
        if (this.acquisitionListenerList == null) {
            this.acquisitionListenerList = new ArrayList();
        }
        this.acquisitionListenerList.add(listener);
    }

    public synchronized void removeAcquisitionListener(AcquisitionListener listener) {
        if (this.acquisitionListenerList != null) {
            this.acquisitionListenerList.remove(listener);
        }
    }

    protected synchronized void fireAcquisitionListenerPauseSpectrometerAcquisitions(Spectrometer event) throws IOException {
        if (this.acquisitionListenerList != null) {
            for (int i = 0; i < this.acquisitionListenerList.size(); ++i) {
                ((AcquisitionListener)this.acquisitionListenerList.get(i)).pauseSpectrometerAcquisitions(event);
            }
        }
    }

    protected synchronized void fireAcquisitionListenerResumeSpectrometerAcquisitions(Spectrometer event) throws IOException {
        if (this.acquisitionListenerList != null) {
            for (int i = 0; i < this.acquisitionListenerList.size(); ++i) {
                ((AcquisitionListener)this.acquisitionListenerList.get(i)).resumeSpectrometerAcquisitions(event);
            }
        }
    }
}

