/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.wavelengthcalibration;

import com.oceanoptics.utilities.Localization;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.table.DefaultTableModel;

public class WavelengthCalibrationTableModel
extends DefaultTableModel {
    private Class[] types = new Class[]{String.class, String.class};
    private static String __extern__ = "__extern__\n<init>,()V\nsetCoefficients,([D)V\ngetCoefficient,(I)D\ngetColumnClass,(I)Ljava/lang/Class;\nisCellEditable,(II)Z\n";

    public WavelengthCalibrationTableModel() {
        super(new String[]{ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("LBL_wl_term"), ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("LBL_wl_coeff_value")}, 0);
    }

    public void setCoefficients(double[] coefficients) {
        DecimalFormat interceptFormat = new DecimalFormat(ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("PREF_wl_intercept_format"));
        DecimalFormat coefFormat = new DecimalFormat(ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("PREF_wl_format"));
        this.setRowCount(4);
        this.setValueAt(ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("LBL_wl_intercept"), 0, 0);
        this.setValueAt(ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("LBL_wl_first_coeff"), 1, 0);
        this.setValueAt(ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("LBL_wl_second_coeff"), 2, 0);
        this.setValueAt(ResourceBundle.getBundle("com.oceanoptics.omnidriver.features.wavelengthcalibration.Bundle").getString("LBL_wl_third_coeff"), 3, 0);
        this.setValueAt(interceptFormat.format(coefficients[0]), 0, 1);
        for (int i = 1; i < 4; ++i) {
            this.setValueAt(coefFormat.format(coefficients[i]), i, 1);
        }
    }

    public double getCoefficient(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return 0.0;
        }
        double retval = 0.0;
        try {
            retval = Localization.parseLocalizedDouble((String)this.getValueAt(row, 1).toString());
        }
        catch (NumberFormatException nfe) {
            this.setValueAt(new String("0"), row, 1);
        }
        return retval;
    }

    public Class getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return 1 == columnIndex;
    }
}

