/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.gramsspc;

import com.oceanoptics.omnidriver.gramsspc.GramsSPCHeader;
import com.oceanoptics.omnidriver.gramsspc.GramsSPCLog;
import com.oceanoptics.omnidriver.gramsspc.GramsSPCSubHeader;
import com.oceanoptics.omnidriver.gramsspc.GramsSPCUtils;
import com.oceanoptics.omnidriver.spectra.AnnotatedSpectrum;
import java.util.Date;

public class GramsSPC {
    private static String __extern__ = "__extern__\n<init>,()V\ngetSPCByteStream,(Lcom/oceanoptics/omnidriver/spectra/AnnotatedSpectrum;)[B\n";

    public static byte[] getSPCByteStream(AnnotatedSpectrum annotatedSpectrum) {
        double[] xArray = annotatedSpectrum.getChannelWavelengths();
        double[] yArray = annotatedSpectrum.getPixelValues();
        int length = xArray.length;
        byte version = 75;
        GramsSPCHeader header = new GramsSPCHeader(version);
        header.setNumberOfPoints(length);
        header.setFirstPointX(xArray[0]);
        header.setLastPointX(xArray[length - 1]);
        header.setXType((byte)3);
        header.setYType((byte)4);
        header.setDate(new Date(annotatedSpectrum.getAcquisitionTime().getTimeMillis()));
        header.setSourceDescription(annotatedSpectrum.getSpectrometerSerialNumber());
        header.setNumberOfSubfiles(1);
        header.setFlags((byte)-128);
        header.setExperiment((byte)0);
        GramsSPCSubHeader subHeader = new GramsSPCSubHeader(version);
        byte[] subHeaderBytes = subHeader.getByteStream();
        byte[] xBytes = GramsSPCUtils.encodeDataArray(xArray, version);
        byte[] yBytes = GramsSPCUtils.encodeDataArray(yArray, version);
        byte[] log = GramsSPC.generateLogBytes(annotatedSpectrum, version);
        header.setLogOffset(header.getLength() + xBytes.length + subHeaderBytes.length + yBytes.length);
        byte[] headerBytes = header.getByteStream();
        int offset = 0;
        int returnSize = headerBytes.length + subHeaderBytes.length + xBytes.length + yBytes.length + log.length;
        byte[] retval = new byte[returnSize];
        offset = GramsSPCUtils.addToStream(headerBytes, retval, offset);
        offset = GramsSPCUtils.addToStream(xBytes, retval, offset);
        offset = GramsSPCUtils.addToStream(subHeaderBytes, retval, offset);
        offset = GramsSPCUtils.addToStream(yBytes, retval, offset);
        offset = GramsSPCUtils.addToStream(log, retval, offset);
        return retval;
    }

    protected static byte[] generateLogBytes(AnnotatedSpectrum annotatedSpectrum, byte version) {
        String comment = new String();
        comment = comment + "MEMO = Int Time: " + annotatedSpectrum.getIntegrationTime() + "us, " + "Averages: " + annotatedSpectrum.getScansToAverage() + ", Boxcar: " + annotatedSpectrum.getBoxcarWidth() + "\r\n";
        comment = comment + "COMMENT = Spectrometer: " + annotatedSpectrum.getSpectrometerSerialNumber() + ", Channel " + annotatedSpectrum.getChannelNumber() + ", Electric dark correction: " + (annotatedSpectrum.getCorrectForElectricalDark() ? "yes" : "no") + ", Non-linearity correction: " + (annotatedSpectrum.getCorrectForNonLinearity() ? "yes" : "no") + ", Stray light correction: " + (annotatedSpectrum.getCorrectForStrayLight() ? "yes" : "no") + ", Detector saturated: " + (annotatedSpectrum.isSaturated() ? "yes" : "no") + ", Strobe/lamp enabled: " + (annotatedSpectrum.isStrobeEnabled() ? "yes" : "no") + " [Ocean Optics SpectraSuite]\r\n";
        comment = comment + "USER = " + annotatedSpectrum.getUserName() + "\r\n";
        GramsSPCLog log = new GramsSPCLog(version);
        log.setTextLog(comment);
        return log.getByteStream();
    }
}

