/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.gramsspc;

import com.oceanoptics.omnidriver.gramsspc.GramsSPCUtils;
import java.util.Date;
import java.util.GregorianCalendar;

public class GramsSPCHeader {
    private static final int SPCHDR_LENGTH = 512;
    private byte ftflags;
    private byte fversn;
    private byte fexper;
    private byte fexp;
    private byte[] fnpts;
    private byte[] ffirst;
    private byte[] flast;
    private byte[] fnsub;
    private byte fxtype;
    private byte fytype;
    private byte fztype;
    private byte fpost;
    private byte[] fdate;
    private byte[] fres;
    private byte[] fsource;
    private byte[] fpeakpt;
    private byte[] fspare;
    private byte[] fcmnt;
    private byte[] fcatxt;
    private byte[] flogoff;
    private byte[] fmods;
    private byte fprocs;
    private byte flevel;
    private byte[] fsampin;
    private byte[] ffactor;
    private byte[] fmethod;
    private byte[] fzinc;
    private byte[] fwplanes;
    private byte[] fwinc;
    private byte fwtype;
    private byte[] freserv;
    private static String __extern__ = "__extern__\n<init>,(B)V\n<init>,([B)V\ngetFlags,()B\nsetFlags,(B)V\ngetVersion,()B\ngetExperiment,()B\nsetExperiment,(B)V\ngetExponent,()B\nsetExponent,(B)V\ngetNumberOfPoints,()I\nsetNumberOfPoints,(I)V\ngetFirstPointX,()D\nsetFirstPointX,(D)V\ngetLastPointX,()D\nsetLastPointX,(D)V\ngetNumberOfSubfiles,()I\nsetNumberOfSubfiles,(I)V\ngetXType,()B\nsetXType,(B)V\ngetYType,()B\nsetYType,(B)V\ngetZType,()B\nsetZType,(B)V\ngetPostingDisposition,()B\nsetPostingDisposition,(B)V\ngetDate,()Ljava/util/Date;\nsetDate,(Ljava/util/Date;)V\ngetResolutionDescription,()Ljava/lang/String;\nsetResolutionDescription,(Ljava/lang/String;)V\ngetSourceDescription,()Ljava/lang/String;\nsetSourceDescription,(Ljava/lang/String;)V\ngetPeakPoint,()S\nsetPeakPoint,(S)V\ngetComment,()Ljava/lang/String;\nsetComment,(Ljava/lang/String;)V\ngetAxisLabelStrings,()Ljava/lang/String;\nsetAxisLabelStrings,(Ljava/lang/String;)V\ngetLogOffset,()I\nsetLogOffset,(I)V\ngetModificationFlags,()I\nsetModificationFlags,(I)V\ngetZSubfileIncrement,()F\nsetZSubfileIncrement,(F)V\ngetNumberOfWPlanes,()I\nsetNumberOfWPlanes,(I)V\ngetWPlaneIncrement,()F\nsetWPlaneIncrement,(F)V\ngetWType,()B\nsetWType,(B)V\ngetLength,()I\ngetByteStream,()[B\n";

    public GramsSPCHeader(byte version) {
        this.fversn = version;
        this.fexp = (byte)-128;
        this.fnpts = new byte[4];
        this.ffirst = new byte[8];
        this.flast = new byte[8];
        this.fnsub = new byte[4];
        this.fdate = new byte[4];
        this.fres = new byte[9];
        this.fsource = new byte[9];
        this.fpeakpt = new byte[2];
        this.fspare = new byte[32];
        this.fcmnt = new byte[130];
        this.fcatxt = new byte[30];
        this.flogoff = new byte[4];
        this.fmods = new byte[4];
        this.fsampin = new byte[2];
        this.ffactor = new byte[4];
        this.fmethod = new byte[48];
        this.fzinc = new byte[4];
        this.fwplanes = new byte[4];
        this.fwinc = new byte[4];
        this.freserv = new byte[187];
    }

    public GramsSPCHeader(byte[] rawBytes) {
    }

    public byte getFlags() {
        return this.ftflags;
    }

    public void setFlags(byte b) {
        this.ftflags = b;
    }

    public byte getVersion() {
        return this.fversn;
    }

    public byte getExperiment() {
        return this.fexper;
    }

    public void setExperiment(byte e) {
        this.fexper = e;
    }

    public byte getExponent() {
        return this.fexp;
    }

    public void setExponent(byte b) {
        this.fexp = b;
    }

    public int getNumberOfPoints() {
        return GramsSPCUtils.decodeInteger32(this.fnpts, this.getVersion());
    }

    public void setNumberOfPoints(int number) {
        this.fnpts = GramsSPCUtils.encodeInteger32(number, this.getVersion());
    }

    public double getFirstPointX() {
        return GramsSPCUtils.decodeDouble64(this.ffirst, this.getVersion());
    }

    public void setFirstPointX(double first) {
        this.ffirst = GramsSPCUtils.encodeDouble64(first, this.getVersion());
    }

    public double getLastPointX() {
        return GramsSPCUtils.decodeDouble64(this.flast, this.getVersion());
    }

    public void setLastPointX(double last) {
        this.flast = GramsSPCUtils.encodeDouble64(last, this.getVersion());
    }

    public int getNumberOfSubfiles() {
        return GramsSPCUtils.decodeInteger32(this.fnsub, this.getVersion());
    }

    public void setNumberOfSubfiles(int n) {
        this.fnsub = GramsSPCUtils.encodeInteger32(n, this.getVersion());
    }

    public byte getXType() {
        return this.fxtype;
    }

    public void setXType(byte type) {
        this.fxtype = type;
    }

    public byte getYType() {
        return this.fytype;
    }

    public void setYType(byte type) {
        this.fytype = type;
    }

    public byte getZType() {
        return this.fztype;
    }

    public void setZType(byte type) {
        this.fztype = type;
    }

    public byte getPostingDisposition() {
        return this.fpost;
    }

    public void setPostingDisposition(byte pd) {
        this.fpost = pd;
    }

    public Date getDate() {
        int packed = GramsSPCUtils.decodeInteger32(this.fdate, this.getVersion());
        int year = (packed & 0xFFF00000) >> 20;
        int month = (packed & 0xF0000) >> 16;
        int day = (packed & 0xF800) >> 11;
        int hour = (packed & 0x7C0) >> 5;
        int minute = packed & 0x3F;
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.set(year, month - 1, day, hour, minute);
        return c.getTime();
    }

    public void setDate(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int packed = minute & 0x3F;
        packed |= (hour & 0x1F) << 6;
        packed |= (day & 0x1F) << 11;
        packed |= (month & 0xF) << 16;
        this.fdate = GramsSPCUtils.encodeInteger32(packed |= (year & 0xFFF) << 20, this.getVersion());
    }

    public String getResolutionDescription() {
        return GramsSPCUtils.decodeString(this.fres);
    }

    public void setResolutionDescription(String description) {
        this.fres = GramsSPCUtils.encodeString(description, 9);
    }

    public String getSourceDescription() {
        return GramsSPCUtils.decodeString(this.fsource);
    }

    public void setSourceDescription(String desc) {
        this.fsource = GramsSPCUtils.encodeString(desc, 9);
    }

    public short getPeakPoint() {
        return GramsSPCUtils.decodeInteger16(this.fpeakpt, this.getVersion());
    }

    public void setPeakPoint(short point) {
        this.fpeakpt = GramsSPCUtils.encodeInteger16(point, this.getVersion());
    }

    public String getComment() {
        return GramsSPCUtils.decodeString(this.fcmnt);
    }

    public void setComment(String comment) {
        this.fcmnt = GramsSPCUtils.encodeString(comment, 130);
    }

    public String getAxisLabelStrings() {
        return GramsSPCUtils.decodeString(this.fcatxt);
    }

    public void setAxisLabelStrings(String labels) {
        this.fcatxt = GramsSPCUtils.encodeString(labels, 30);
    }

    public int getLogOffset() {
        return GramsSPCUtils.decodeInteger32(this.flogoff, this.getVersion());
    }

    public void setLogOffset(int offset) {
        this.flogoff = GramsSPCUtils.encodeInteger32(offset, this.getVersion());
    }

    public int getModificationFlags() {
        return GramsSPCUtils.decodeInteger32(this.fmods, this.getVersion());
    }

    public void setModificationFlags(int flags) {
        this.fmods = GramsSPCUtils.encodeInteger32(flags, this.getVersion());
    }

    public float getZSubfileIncrement() {
        return GramsSPCUtils.decodeFloat32(this.fzinc, this.getVersion());
    }

    public void setZSubfileIncrement(float inc) {
        this.fzinc = GramsSPCUtils.encodeFloat32(inc, this.getVersion());
    }

    public int getNumberOfWPlanes() {
        return GramsSPCUtils.decodeInteger32(this.fwplanes, this.getVersion());
    }

    public void setNumberOfWPlanes(int planes) {
        this.fwplanes = GramsSPCUtils.encodeInteger32(planes, this.getVersion());
    }

    public float getWPlaneIncrement() {
        return GramsSPCUtils.decodeFloat32(this.fwinc, this.getVersion());
    }

    public void setWPlaneIncrement(float inc) {
        this.fwinc = GramsSPCUtils.encodeFloat32(inc, this.getVersion());
    }

    public byte getWType() {
        return this.fwtype;
    }

    public void setWType(byte type) {
        this.fwtype = type;
    }

    public int getLength() {
        return 512;
    }

    public byte[] getByteStream() {
        byte[] bs = new byte[512];
        bs[0] = this.ftflags;
        bs[1] = this.fversn;
        bs[2] = this.fexper;
        bs[3] = this.fexp;
        int offset = 4;
        offset = GramsSPCUtils.addToStream(this.fnpts, bs, offset);
        offset = GramsSPCUtils.addToStream(this.ffirst, bs, offset);
        offset = GramsSPCUtils.addToStream(this.flast, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fnsub, bs, offset);
        bs[offset] = this.fxtype;
        bs[++offset] = this.fytype;
        bs[++offset] = this.fztype;
        bs[++offset] = this.fpost;
        ++offset;
        offset = GramsSPCUtils.addToStream(this.fdate, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fres, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fsource, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fpeakpt, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fspare, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fcmnt, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fcatxt, bs, offset);
        offset = GramsSPCUtils.addToStream(this.flogoff, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fmods, bs, offset);
        bs[offset] = this.fprocs;
        bs[++offset] = this.flevel;
        ++offset;
        offset = GramsSPCUtils.addToStream(this.fsampin, bs, offset);
        offset = GramsSPCUtils.addToStream(this.ffactor, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fmethod, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fzinc, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fwplanes, bs, offset);
        offset = GramsSPCUtils.addToStream(this.fwinc, bs, offset);
        bs[offset] = this.fwtype;
        ++offset;
        offset = GramsSPCUtils.addToStream(this.freserv, bs, offset);
        return bs;
    }
}

