/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.gramsspc;

import com.oceanoptics.omnidriver.gramsspc.GramsSPCUtils;

public class GramsSPCSubHeader {
    private byte formatVersion;
    private static final int SUBHDR_LENGTH = 32;
    public static final byte SUBFILE_CHANGED = 1;
    public static final byte PEAK_TABLE_NOT_USED = 8;
    public static final byte MODIFIED_BY_ARITHMETIC = -128;
    private byte subflgs;
    private byte subexp;
    private byte[] subindx;
    private byte[] subtime;
    private byte[] subnext;
    private byte[] subnois;
    private byte[] subnpts;
    private byte[] subscan;
    private byte[] subwlevel;
    private byte[] subresv;
    private static String __extern__ = "__extern__\n<init>,(B)V\ngetSubFlags,()B\nsetSubFlags,(B)V\ngetSubExponent,()B\nsetSubExponent,(B)V\ngetSubIndex,()S\nsetSubIndex,(S)V\ngetSubTime,()F\nsetSubTime,(F)V\ngetSubNext,()F\nsetSubNext,(F)V\ngetSubNoise,()F\nsetSubNoise,(F)V\ngetNumberOfPoints,()I\nsetNumberOfPoints,(I)V\ngetNumberOfScans,()I\nsetNumberOfScans,(I)V\ngetSubWLevel,()F\nsetSubWLevel,(F)V\ngetLength,()I\ngetByteStream,()[B\n";

    public GramsSPCSubHeader(byte version) {
        this.formatVersion = version;
        this.subexp = (byte)-128;
        this.subindx = new byte[2];
        this.subtime = new byte[4];
        this.subnext = new byte[4];
        this.subnois = new byte[4];
        this.subnpts = new byte[4];
        this.subscan = new byte[4];
        this.subwlevel = new byte[4];
        this.subresv = new byte[4];
    }

    public byte getSubFlags() {
        return this.subflgs;
    }

    public void setSubFlags(byte flags) {
        this.subflgs = flags;
    }

    public byte getSubExponent() {
        return this.subexp;
    }

    public void setSubExponent(byte exp) {
        this.subexp = exp;
    }

    public short getSubIndex() {
        return GramsSPCUtils.decodeInteger16(this.subindx, this.formatVersion);
    }

    public void setSubIndex(short index) {
        this.subindx = GramsSPCUtils.encodeInteger16(index, this.formatVersion);
    }

    public float getSubTime() {
        return GramsSPCUtils.decodeFloat32(this.subtime, this.formatVersion);
    }

    public void setSubTime(float time) {
        this.subtime = GramsSPCUtils.encodeFloat32(time, this.formatVersion);
    }

    public float getSubNext() {
        return GramsSPCUtils.decodeFloat32(this.subnext, this.formatVersion);
    }

    public void setSubNext(float next) {
        this.subnext = GramsSPCUtils.encodeFloat32(next, this.formatVersion);
    }

    public float getSubNoise() {
        return GramsSPCUtils.decodeFloat32(this.subnois, this.formatVersion);
    }

    public void setSubNoise(float noise) {
        this.subnois = GramsSPCUtils.encodeFloat32(noise, this.formatVersion);
    }

    public int getNumberOfPoints() {
        return GramsSPCUtils.decodeInteger32(this.subnpts, this.formatVersion);
    }

    public void setNumberOfPoints(int points) {
        this.subnpts = GramsSPCUtils.encodeInteger32(points, this.formatVersion);
    }

    public int getNumberOfScans() {
        return GramsSPCUtils.decodeInteger32(this.subscan, this.formatVersion);
    }

    public void setNumberOfScans(int scans) {
        this.subscan = GramsSPCUtils.encodeInteger32(scans, this.formatVersion);
    }

    public float getSubWLevel() {
        return GramsSPCUtils.decodeFloat32(this.subwlevel, this.formatVersion);
    }

    public void setSubWLevel(float level) {
        this.subwlevel = GramsSPCUtils.encodeFloat32(level, this.formatVersion);
    }

    public int getLength() {
        return 32;
    }

    public byte[] getByteStream() {
        byte[] bs = new byte[32];
        bs[0] = this.subflgs;
        bs[1] = this.subexp;
        int offset = 2;
        offset = GramsSPCUtils.addToStream(this.subindx, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subtime, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subnext, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subnois, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subnpts, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subscan, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subwlevel, bs, offset);
        offset = GramsSPCUtils.addToStream(this.subresv, bs, offset);
        return bs;
    }
}

