/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.gramsspc;

import java.io.UnsupportedEncodingException;

public class GramsSPCUtils {
    private static String __extern__ = "__extern__\ndecodeInteger32,([BB)I\nencodeInteger32,(IB)[B\ndecodeInteger16,([BB)S\nencodeInteger16,(SB)[B\ndecodeDouble64,([BB)D\nencodeDouble64,(DB)[B\ndecodeFloat32,([BB)F\nencodeFloat32,(FB)[B\ndecodeString,([B)Ljava/lang/String;\nencodeString,(Ljava/lang/String;I)[B\nencodeString,(Ljava/lang/String;)[B\naddToStream,([B[BI)I\nencodeDataArray,([DB)[B\n";

    private GramsSPCUtils() {
    }

    public static int decodeInteger32(byte[] data, byte version) {
        int retval;
        if (75 == version | 77 == version) {
            retval = data[3] << 24 | data[2] << 16 | data[1] << 8 | data[0];
        } else if (76 == version) {
            retval = data[0] << 24 | data[1] << 16 | data[2] << 8 | data[3];
        } else {
            throw new IllegalStateException("Cannot decode data with invalid file version");
        }
        return retval;
    }

    public static byte[] encodeInteger32(int i, byte version) {
        byte[] retval = new byte[4];
        if (75 == version | 77 == version) {
            retval[0] = (byte)(i & 0xFF);
            retval[1] = (byte)((i & 0xFF00) >> 8);
            retval[2] = (byte)((i & 0xFF0000) >> 16);
            retval[3] = (byte)((i & 0xFF000000) >> 24);
        } else if (76 == version) {
            retval[3] = (byte)(i & 0xFF);
            retval[2] = (byte)((i & 0xFF00) >> 8);
            retval[1] = (byte)((i & 0xFF0000) >> 16);
            retval[0] = (byte)((i & 0xFF000000) >> 24);
        } else {
            throw new IllegalStateException("Cannot encode data with invalid file version");
        }
        return retval;
    }

    public static short decodeInteger16(byte[] data, byte version) {
        short retval;
        if (75 == version | 77 == version) {
            retval = (short)(data[1] << 8 | data[0]);
        } else if (76 == version) {
            retval = (short)(data[0] << 8 | data[1]);
        } else {
            throw new IllegalStateException("Cannot decode data with invalid file version");
        }
        return retval;
    }

    public static byte[] encodeInteger16(short s, byte version) {
        byte[] retval = new byte[2];
        if (75 == version | 77 == version) {
            retval[0] = (byte)(s & 0xFF);
            retval[1] = (byte)((s & 0xFF00) >> 8);
        } else if (76 == version) {
            retval[1] = (byte)(s & 0xFF);
            retval[0] = (byte)((s & 0xFF00) >> 8);
        } else {
            throw new IllegalStateException("Cannot encode data with invalid file version");
        }
        return retval;
    }

    public static double decodeDouble64(byte[] data, byte version) {
        long l;
        if (75 == version | 77 == version) {
            l = data[7] << 56 | data[6] << 48 | data[5] << 40 | data[4] << 32 | data[3] << 24 | data[2] << 16 | data[1] << 8 | data[0];
        } else if (76 == version) {
            l = data[0] << 56 | data[1] << 48 | data[2] << 40 | data[3] << 32 | data[4] << 24 | data[5] << 16 | data[6] << 8 | data[7];
        } else {
            throw new IllegalStateException("Cannot decode data with invalid file version");
        }
        double retval = Double.longBitsToDouble(l);
        return retval;
    }

    public static byte[] encodeDouble64(double d, byte version) {
        byte[] retval = new byte[8];
        long l = Double.doubleToLongBits(d);
        if (75 == version | 77 == version) {
            retval[0] = (byte)(l & 0xFFL);
            retval[1] = (byte)((l & 0xFF00L) >> 8);
            retval[2] = (byte)((l & 0xFF0000L) >> 16);
            retval[3] = (byte)((l & 0xFF000000L) >> 24);
            retval[4] = (byte)((l & 0xFF00000000L) >> 32);
            retval[5] = (byte)((l & 0xFF0000000000L) >> 40);
            retval[6] = (byte)((l & 0xFF000000000000L) >> 48);
            retval[7] = (byte)((l & 0xFF00000000000000L) >> 56);
        } else if (76 == version) {
            retval[7] = (byte)(l & 0xFFL);
            retval[6] = (byte)((l & 0xFF00L) >> 8);
            retval[5] = (byte)((l & 0xFF0000L) >> 16);
            retval[4] = (byte)((l & 0xFF000000L) >> 24);
            retval[3] = (byte)((l & 0xFF00000000L) >> 32);
            retval[2] = (byte)((l & 0xFF0000000000L) >> 40);
            retval[1] = (byte)((l & 0xFF000000000000L) >> 48);
            retval[0] = (byte)((l & 0xFF00000000000000L) >> 56);
        } else {
            throw new IllegalStateException("Cannot encode data with invalid file version");
        }
        return retval;
    }

    public static float decodeFloat32(byte[] data, byte version) {
        int i;
        if (75 == version | 77 == version) {
            i = data[3] << 24 | data[2] << 16 | data[1] << 8 | data[0];
        } else if (76 == version) {
            i = data[0] << 24 | data[1] << 16 | data[2] << 8 | data[3];
        } else {
            throw new IllegalStateException("Cannot decode data with invalid file version");
        }
        float retval = Float.intBitsToFloat(i);
        return retval;
    }

    public static byte[] encodeFloat32(float f, byte version) {
        byte[] retval = new byte[4];
        int i = Float.floatToIntBits(f);
        if (75 == version | 77 == version) {
            retval[0] = (byte)((long)i & 0xFFL);
            retval[1] = (byte)(((long)i & 0xFF00L) >> 8);
            retval[2] = (byte)(((long)i & 0xFF0000L) >> 16);
            retval[3] = (byte)(((long)i & 0xFF000000L) >> 24);
        } else if (76 == version) {
            retval[3] = (byte)((long)i & 0xFFL);
            retval[2] = (byte)(((long)i & 0xFF00L) >> 8);
            retval[1] = (byte)(((long)i & 0xFF0000L) >> 16);
            retval[0] = (byte)(((long)i & 0xFF000000L) >> 24);
        } else {
            throw new IllegalStateException("Cannot encode data with invalid file version");
        }
        return retval;
    }

    public static String decodeString(byte[] data) {
        if (0 == data[0]) {
            return new String();
        }
        try {
            return new String(data, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return new String();
        }
    }

    public static byte[] encodeString(String string, int maxLength) {
        if (string.length() == 0) {
            return new byte[maxLength];
        }
        try {
            byte[] bytes = string.getBytes("US-ASCII");
            byte[] res = new byte[maxLength];
            int len = Math.min(maxLength, bytes.length);
            for (int i = 0; i < len; ++i) {
                res[i] = bytes[i];
            }
            res[maxLength - 1] = 0;
            return res;
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[maxLength];
        }
    }

    public static byte[] encodeString(String string) {
        if (string.length() == 0) {
            return new byte[0];
        }
        try {
            byte[] stringBytes = string.getBytes("US-ASCII");
            byte[] ascii = new byte[stringBytes.length + 1];
            System.arraycopy(stringBytes, 0, ascii, 0, stringBytes.length);
            ascii[ascii.length - 1] = 0;
            return ascii;
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[0];
        }
    }

    public static int addToStream(byte[] source, byte[] target, int offset) {
        System.arraycopy(source, 0, target, offset, source.length);
        return source.length + offset;
    }

    public static byte[] encodeDataArray(double[] array, byte version) {
        byte[] bs = new byte[array.length * 4];
        for (int i = 0; i < array.length; ++i) {
            byte[] floatBytes = GramsSPCUtils.encodeFloat32((float)array[i], version);
            GramsSPCUtils.addToStream(floatBytes, bs, i * 4);
        }
        return bs;
    }
}

