/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.plugin;

import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.interfaces.FeatureProvider;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import java.io.IOException;
import java.util.HashMap;

public abstract class SpectrometerPlugIn
implements FeatureProvider {
    private static HashMap products = new HashMap();
    private int productID;
    protected byte[] out;
    protected byte[] in;
    protected USBSpectrometer spectrometer;
    private static String __extern__;

    protected SpectrometerPlugIn(USBSpectrometer spec, int prodID) throws IOException {
        this.spectrometer = spec;
        this.productID = prodID;
        this.in = spec.getInputBuffer();
        this.out = spec.getOutputBuffer();
        if (this.spectrometer instanceof PlugInProvider) {
            PlugInProvider pip = (PlugInProvider)((Object)this.spectrometer);
            boolean detected = pip.isPlugInDetected(this.productID);
            if (!detected) {
                throw new IOException(this.getName() + " not detected.");
            }
        } else {
            throw new IOException(spec.getName() + " does not support plugins");
        }
    }

    protected int makeVersion(int v1, int v2, int v3) {
        return v1 * 1000000 + v2 * 1000 + v3;
    }

    public static String getName(int productID) {
        return ((ProductInfo)SpectrometerPlugIn.products.get((Object)new Integer((int)productID))).name;
    }

    public String getName() {
        return ((ProductInfo)SpectrometerPlugIn.products.get((Object)new Integer((int)this.productID))).name;
    }

    public static String getClassName(int productID) {
        System.out.println("Product id for plugin is " + productID);
        return ((ProductInfo)SpectrometerPlugIn.products.get((Object)new Integer((int)productID))).className;
    }

    public String getClassName() {
        return ((ProductInfo)SpectrometerPlugIn.products.get((Object)new Integer((int)this.productID))).className;
    }

    public USBSpectrometer getUSBSpectrometer() {
        return this.spectrometer;
    }

    static {
        products.put(new Integer(1), new ProductInfo("USB-ISS", "com.oceanoptics.omnidriver.plugin.USB_ISS"));
        products.put(new Integer(2), new ProductInfo("USB-LS-450", "com.oceanoptics.omnidriver.plugin.USB_LS450"));
        products.put(new Integer(3), new ProductInfo("USB-ISS-UV", "com.oceanoptics.omnidriver.plugin.USB_ISS_UV"));
        __extern__ = "__extern__\ngetName,(I)Ljava/lang/String;\ngetName,()Ljava/lang/String;\ngetClassName,(I)Ljava/lang/String;\ngetClassName,()Ljava/lang/String;\ngetUSBSpectrometer,()Lcom/oceanoptics/omnidriver/spectrometer/USBSpectrometer;\n";
    }

    private static class ProductInfo {
        public String name;
        public String className;

        ProductInfo(String name, String className) {
            this.name = name;
            this.className = className;
        }
    }
}

