/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectra;

import com.oceanoptics.highrestiming.HighResTimeStamp;
import com.oceanoptics.omnidriver.spectra.SpectrometerChannelInfo;
import com.oceanoptics.spectralprocessing.SpectrumCertificate;
import java.util.Vector;

public class OmniSpectrum
extends SpectrometerChannelInfo {
    private boolean saturated;
    private int integrationTime;
    private boolean strobeEnabled;
    private int strobeDelay;
    private double[] pixelValues;
    private HighResTimeStamp acquisitionTime;
    private int boxcarWidth;
    private int scansToAverage;
    private boolean correctForElectricalDark;
    private boolean correctForNonLinearity;
    private boolean correctForStrayLight;
    private boolean rotationEnabled;
    private Vector certificates;
    private String userName;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectra/OmniSpectrum;)V\n<init>,(Lcom/oceanoptics/omnidriver/spectra/SpectrometerChannelInfo;)V\n<init>,(Lcom/oceanoptics/omnidriver/spectra/SpectrometerChannelInfo;[DZILcom/oceanoptics/highrestiming/HighResTimeStamp;IIZZZZIZLjava/lang/String;)V\ngetCopyWithUniqueCertificates,()Lcom/oceanoptics/omnidriver/spectra/OmniSpectrum;\nisSaturated,()Z\nsetSaturated,(Z)V\ngetIntegrationTime,()I\nsetIntegrationTime,(I)V\nisStrobeEnabled,()Z\nsetStrobeEnabled,(Z)V\ngetStrobeDelay,()I\nsetStrobeDelay,(I)V\ngetPixelValues,()[D\nsetPixelValues,([D)V\ngetAcquisitionTime,()Lcom/oceanoptics/highrestiming/HighResTimeStamp;\nsetAcquisitionTime,(Lcom/oceanoptics/highrestiming/HighResTimeStamp;)V\ngetBoxcarWidth,()I\nsetBoxcarWidth,(I)V\ngetScansToAverage,()I\nsetScanToAverage,(I)V\nisCorrectForElectricalDark,()Z\nsetCorrectForElectricalDark,(Z)V\nisCorrectForNonLinearity,()Z\nsetCorrectForNonLinearity,(Z)V\nisCorrectForStrayLight,()Z\nsetCorrectForStrayLight,(Z)V\nisRotationEnabled,()Z\nsetRotationEnabled,(Z)V\ngetUserName,()Ljava/lang/String;\nsetUserName,(Ljava/lang/String;)V\ngetCertificates,()Ljava/util/Vector;\naddCertificate,(Lcom/oceanoptics/spectralprocessing/SpectrumCertificate;)V\ntoString,()Ljava/lang/String;\n";

    public OmniSpectrum(OmniSpectrum omniSpectrum) {
        super(omniSpectrum);
        this.saturated = omniSpectrum.saturated;
        this.integrationTime = omniSpectrum.integrationTime;
        this.strobeEnabled = omniSpectrum.strobeEnabled;
        this.strobeDelay = omniSpectrum.strobeDelay;
        this.pixelValues = omniSpectrum.pixelValues;
        this.acquisitionTime = omniSpectrum.acquisitionTime;
        this.boxcarWidth = omniSpectrum.boxcarWidth;
        this.scansToAverage = omniSpectrum.scansToAverage;
        this.correctForElectricalDark = omniSpectrum.correctForElectricalDark;
        this.correctForNonLinearity = omniSpectrum.correctForNonLinearity;
        this.correctForStrayLight = omniSpectrum.correctForStrayLight;
        this.rotationEnabled = omniSpectrum.rotationEnabled;
        this.certificates = omniSpectrum.certificates;
        this.userName = omniSpectrum.userName;
    }

    public OmniSpectrum(SpectrometerChannelInfo spectrometerChannelInfo) {
        super(spectrometerChannelInfo);
        this.saturated = false;
        this.integrationTime = 0;
        this.strobeEnabled = false;
        this.strobeDelay = 0;
        this.pixelValues = new double[0];
        this.acquisitionTime = new HighResTimeStamp();
        this.boxcarWidth = 0;
        this.scansToAverage = 0;
        this.correctForElectricalDark = false;
        this.correctForNonLinearity = false;
        this.correctForStrayLight = false;
        this.rotationEnabled = false;
        this.certificates = new Vector();
        this.userName = new String();
    }

    public OmniSpectrum(SpectrometerChannelInfo spectrometerChannelInfo, double[] spectrum, boolean saturated, int integrationTime, HighResTimeStamp acquisitionTime, int boxcarWidth, int scansToAverage, boolean correctForElectricalDark, boolean correctForNonLinearity, boolean correctForStrayLight, boolean strobeEnabled, int strobeDelay, boolean rotationEnabled, String userName) {
        super(spectrometerChannelInfo);
        this.saturated = saturated;
        this.integrationTime = integrationTime;
        this.strobeEnabled = strobeEnabled;
        this.strobeDelay = strobeDelay;
        this.pixelValues = spectrum;
        this.acquisitionTime = acquisitionTime;
        this.boxcarWidth = boxcarWidth;
        this.scansToAverage = scansToAverage;
        this.correctForElectricalDark = correctForElectricalDark;
        this.correctForNonLinearity = correctForNonLinearity;
        this.correctForStrayLight = correctForStrayLight;
        this.rotationEnabled = rotationEnabled;
        this.userName = userName;
        this.certificates = new Vector();
    }

    public OmniSpectrum getCopyWithUniqueCertificates() {
        Vector newCertificates;
        OmniSpectrum os = new OmniSpectrum(this);
        os.certificates = newCertificates = new Vector(os.certificates);
        return os;
    }

    public boolean isSaturated() {
        return this.saturated;
    }

    public void setSaturated(boolean saturated) {
        this.saturated = saturated;
    }

    public int getIntegrationTime() {
        return this.integrationTime;
    }

    public void setIntegrationTime(int integrationTime) {
        this.integrationTime = integrationTime;
    }

    public boolean isStrobeEnabled() {
        return this.strobeEnabled;
    }

    public void setStrobeEnabled(boolean strobeEnabled) {
        this.strobeEnabled = strobeEnabled;
    }

    public int getStrobeDelay() {
        return this.strobeDelay;
    }

    public void setStrobeDelay(int strobeDelay) {
        this.strobeDelay = strobeDelay;
    }

    public double[] getPixelValues() {
        return this.pixelValues;
    }

    public void setPixelValues(double[] pixelValues) {
        this.pixelValues = pixelValues;
    }

    public HighResTimeStamp getAcquisitionTime() {
        return this.acquisitionTime;
    }

    public void setAcquisitionTime(HighResTimeStamp acquisitionTime) {
        this.acquisitionTime = acquisitionTime;
    }

    public int getBoxcarWidth() {
        return this.boxcarWidth;
    }

    public void setBoxcarWidth(int boxcarWidth) {
        this.boxcarWidth = boxcarWidth;
    }

    public int getScansToAverage() {
        return this.scansToAverage;
    }

    public void setScanToAverage(int scansToAverage) {
        this.scansToAverage = scansToAverage;
    }

    public boolean isCorrectForElectricalDark() {
        return this.correctForElectricalDark;
    }

    public void setCorrectForElectricalDark(boolean correctForElectricalDark) {
        this.correctForElectricalDark = correctForElectricalDark;
    }

    public boolean isCorrectForNonLinearity() {
        return this.correctForNonLinearity;
    }

    public void setCorrectForNonLinearity(boolean correctForNonLinearity) {
        this.correctForNonLinearity = correctForNonLinearity;
    }

    public boolean isCorrectForStrayLight() {
        return this.correctForStrayLight;
    }

    public void setCorrectForStrayLight(boolean correctForStrayLight) {
        this.correctForStrayLight = correctForStrayLight;
    }

    public boolean isRotationEnabled() {
        return this.rotationEnabled;
    }

    public void setRotationEnabled(boolean rotationEnabled) {
        this.rotationEnabled = rotationEnabled;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Vector getCertificates() {
        return this.certificates;
    }

    public void addCertificate(SpectrumCertificate certificate) {
        SpectrumCertificate spectrumCertificate = new SpectrumCertificate(certificate);
        this.certificates.add(spectrumCertificate);
    }

    public String toString() {
        String s = null;
        s = "OmniSpectrum: \nIntegration time: " + this.getIntegrationTime() + "\nNumber of pixels: " + this.getPixelValues().length + "\nScans to average: " + this.getScansToAverage();
        return s;
    }
}

