/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

public class Coefficients {
    public static final int WL_INTERCEPT = 1;
    public static final int WL_FIRST = 2;
    public static final int WL_SECOND = 3;
    public static final int WL_THIRD = 4;
    public static final int STRAY_LIGHT = 5;
    public static final int NL_0 = 6;
    public static final int NL_1 = 7;
    public static final int NL_2 = 8;
    public static final int NL_3 = 9;
    public static final int NL_4 = 10;
    public static final int NL_5 = 11;
    public static final int NL_6 = 12;
    public static final int NL_7 = 13;
    public static final int NL_ORDER = 14;
    protected double _WlIntercept;
    protected double _WlFirst;
    protected double _WlSecond;
    protected double _WlThird;
    protected double _StrayLight;
    protected double strayLightSlope;
    protected double _NlCoef0;
    protected double _NlCoef1;
    protected double _NlCoef2;
    protected double _NlCoef3;
    protected double _NlCoef4;
    protected double _NlCoef5;
    protected double _NlCoef6;
    protected double _NlCoef7;
    protected int _NlOrder;
    protected boolean has_WlIntercept = false;
    protected boolean has_WlFirst = false;
    protected boolean has_WlSecond = false;
    protected boolean has_WlThird = false;
    protected boolean has_StrayLight = false;
    protected boolean has_NlCoef0 = false;
    protected boolean has_NlCoef1 = false;
    protected boolean has_NlCoef2 = false;
    protected boolean has_NlCoef3 = false;
    protected boolean has_NlCoef4 = false;
    protected boolean has_NlCoef5 = false;
    protected boolean has_NlCoef6 = false;
    protected boolean has_NlCoef7 = false;
    protected boolean has_NlOrder = false;
    private final String[] DESCRIPTIONS = new String[]{"0th order wavelength calibration coefficient", "1st order wavelength calibration coefficient", "2nd order wavelength calibration coefficient", "3rd order wavelength calibration coefficient", "Stray light constant", "0th order non-linearity correction coefficient", "1st order non-linearity correction coefficient", "2nd order non-linearity correction coefficient", "3rd order non-linearity correction coefficient", "4th order non-linearity correction coefficient", "5th order non-linearity correction coefficient", "6th order non-linearity correction coefficient", "7th order non-linearity correction coefficient", "Polynomial order of non-linearity calibration"};
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetDescriptions,()[Ljava/lang/String;\ngetWlIntercept,()D\nsetWlIntercept,(D)V\ngetWlFirst,()D\nsetWlFirst,(D)V\ngetWlSecond,()D\nsetWlSecond,(D)V\ngetWlThird,()D\nsetWlThird,(D)V\ngetWlCoefficients,()[D\nsetWlCoefficients,([D)V\ngetNlCoef0,()D\nsetNlCoef0,(D)V\ngetNlCoef1,()D\nsetNlCoef1,(D)V\ngetNlCoef2,()D\nsetNlCoef2,(D)V\ngetNlCoef3,()D\nsetNlCoef3,(D)V\ngetNlCoef4,()D\nsetNlCoef4,(D)V\ngetNlCoef5,()D\nsetNlCoef5,(D)V\ngetNlCoef6,()D\nsetNlCoef6,(D)V\ngetNlCoef7,()D\nsetNlCoef7,(D)V\ngetNlOrder,()I\nsetNlOrder,(I)V\ngetNlCoefficients,()[D\nsetNlCoefficients,([D)V\ngetStrayLight,()D\ngetStrayLightSlope,()D\nsetStrayLight,(D)V\nsetStrayLight,(DD)V\ntoString,()Ljava/lang/String;\n";

    public Coefficients() {
    }

    public Coefficients(Coefficients c) {
        this.setWlIntercept(c.getWlIntercept());
        this.setWlFirst(c.getWlFirst());
        this.setWlSecond(c.getWlSecond());
        this.setWlThird(c.getWlThird());
        this.setStrayLight(c.getStrayLight(), c.getStrayLightSlope());
        this.setNlCoef0(c.getNlCoef0());
        this.setNlCoef1(c.getNlCoef1());
        this.setNlCoef2(c.getNlCoef2());
        this.setNlCoef3(c.getNlCoef3());
        this.setNlCoef4(c.getNlCoef4());
        this.setNlCoef5(c.getNlCoef5());
        this.setNlCoef6(c.getNlCoef6());
        this.setNlCoef7(c.getNlCoef7());
        this.setNlOrder(c.getNlOrder());
    }

    public String[] getDescriptions() {
        return this.DESCRIPTIONS;
    }

    public double getWlIntercept() {
        return this._WlIntercept;
    }

    public void setWlIntercept(double value) {
        this._WlIntercept = value;
        this.has_WlIntercept = true;
    }

    public double getWlFirst() {
        return this._WlFirst;
    }

    public void setWlFirst(double value) {
        this._WlFirst = value;
        this.has_WlFirst = true;
    }

    public double getWlSecond() {
        return this._WlSecond;
    }

    public void setWlSecond(double value) {
        this._WlSecond = value;
        this.has_WlSecond = true;
    }

    public double getWlThird() {
        return this._WlThird;
    }

    public void setWlThird(double value) {
        this._WlThird = value;
        this.has_WlThird = true;
    }

    public double[] getWlCoefficients() {
        double[] wl = new double[]{this._WlIntercept, this._WlFirst, this._WlSecond, this._WlThird};
        return wl;
    }

    public void setWlCoefficients(double[] wl) {
        this._WlIntercept = wl[0];
        this.has_WlIntercept = true;
        this._WlFirst = wl[1];
        this.has_WlFirst = true;
        this._WlSecond = wl[2];
        this.has_WlSecond = true;
        this._WlThird = wl[3];
        this.has_WlThird = true;
    }

    public double getNlCoef0() {
        return this._NlCoef0;
    }

    public void setNlCoef0(double value) {
        this._NlCoef0 = value;
        this.has_NlCoef0 = true;
    }

    public double getNlCoef1() {
        return this._NlCoef1;
    }

    public void setNlCoef1(double value) {
        this._NlCoef1 = value;
        this.has_NlCoef1 = true;
    }

    public double getNlCoef2() {
        return this._NlCoef2;
    }

    public void setNlCoef2(double value) {
        this._NlCoef2 = value;
        this.has_NlCoef2 = true;
    }

    public double getNlCoef3() {
        return this._NlCoef3;
    }

    public void setNlCoef3(double value) {
        this._NlCoef3 = value;
        this.has_NlCoef3 = true;
    }

    public double getNlCoef4() {
        return this._NlCoef4;
    }

    public void setNlCoef4(double value) {
        this._NlCoef4 = value;
        this.has_NlCoef4 = true;
    }

    public double getNlCoef5() {
        return this._NlCoef5;
    }

    public void setNlCoef5(double value) {
        this._NlCoef5 = value;
        this.has_NlCoef5 = true;
    }

    public double getNlCoef6() {
        return this._NlCoef6;
    }

    public void setNlCoef6(double value) {
        this._NlCoef6 = value;
        this.has_NlCoef6 = true;
    }

    public double getNlCoef7() {
        return this._NlCoef7;
    }

    public void setNlCoef7(double value) {
        this._NlCoef7 = value;
        this.has_NlCoef7 = true;
    }

    public int getNlOrder() {
        return this._NlOrder;
    }

    public void setNlOrder(int value) {
        this._NlOrder = value;
        this.has_NlOrder = true;
    }

    public double[] getNlCoefficients() {
        double[] nl = new double[]{this._NlCoef0, this._NlCoef1, this._NlCoef2, this._NlCoef3, this._NlCoef4, this._NlCoef5, this._NlCoef6, this._NlCoef7};
        return nl;
    }

    public void setNlCoefficients(double[] nl) {
        this._NlCoef0 = nl[0];
        this.has_NlCoef0 = true;
        this._NlCoef1 = nl[1];
        this.has_NlCoef1 = true;
        this._NlCoef2 = nl[2];
        this.has_NlCoef2 = true;
        this._NlCoef3 = nl[3];
        this.has_NlCoef3 = true;
        this._NlCoef4 = nl[4];
        this.has_NlCoef4 = true;
        this._NlCoef5 = nl[5];
        this.has_NlCoef5 = true;
        this._NlCoef6 = nl[6];
        this.has_NlCoef6 = true;
        this._NlCoef7 = nl[7];
        this.has_NlCoef7 = true;
    }

    public double getStrayLight() {
        return this._StrayLight;
    }

    public double getStrayLightSlope() {
        return this.strayLightSlope;
    }

    public void setStrayLight(double value) {
        this._StrayLight = value;
        this.has_StrayLight = true;
    }

    public void setStrayLight(double intercept, double slope) {
        this.setStrayLight(intercept);
        this.strayLightSlope = slope;
    }

    public String toString() {
        int i = 0;
        return this.DESCRIPTIONS[i++] + " " + this.getWlIntercept() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getWlFirst() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getWlSecond() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getWlThird() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getStrayLight() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef0() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef1() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef2() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef3() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef4() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef5() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef6() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlCoef7() + "\n" + this.DESCRIPTIONS[i++] + " " + this.getNlOrder() + "\n";
    }
}

