/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.spectrometer.Bench;
import com.oceanoptics.omnidriver.spectrometer.Detector;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import java.io.IOException;

public class Configuration {
    protected Bench bench = new Bench();
    protected Detector detector = new Detector();
    protected String cpldVersion;
    public Spectrometer spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;Lcom/oceanoptics/omnidriver/spectrometer/Configuration;)V\ngetConfigurationFromSpectrometer,()V\nsetConfigurationToSpectrometer,()V\ngetBench,()Lcom/oceanoptics/omnidriver/spectrometer/Bench;\nsetBench,(Lcom/oceanoptics/omnidriver/spectrometer/Bench;)V\ngetDetector,()Lcom/oceanoptics/omnidriver/spectrometer/Detector;\nsetDetector,(Lcom/oceanoptics/omnidriver/spectrometer/Detector;)V\ngetCpldVersion,()Ljava/lang/String;\nsetCpldVersion,(Ljava/lang/String;)V\nisBenchDefined,()Z\nisSpectrometerConfigurationDefined,()Z\nisDetectorSerialNumberDefined,()Z\nisCPLDVersionDefined,()Z\ntoString,()Ljava/lang/String;\n";

    public Configuration(Spectrometer spec) throws IOException {
        this.spectrometer = spec;
        this.getConfigurationFromSpectrometer();
    }

    public Configuration(Spectrometer spec, Configuration c) {
        this.spectrometer = spec;
        this.setBench(c.getBench());
        this.setDetector(c.getDetector());
        this.setCpldVersion(c.getCpldVersion());
    }

    public void getConfigurationFromSpectrometer() throws IOException {
        String[] configSlot;
        String[] slot;
        if (this.isBenchDefined() && (slot = this.spectrometer.getInfo(this.spectrometer.getBenchSlot()).split(" ")).length == 3) {
            this.bench.setGrating(slot[0]);
            this.bench.setFilterWavelength(slot[1]);
            this.bench.setSlitSize(slot[2]);
        }
        if (this.isSpectrometerConfigurationDefined() && (configSlot = this.spectrometer.getInfo(this.spectrometer.getSpectrometerConfigSlot()).split(" +")).length == 2) {
            Detector d = this.getDetector();
            String temp = configSlot[0].substring(0, 1);
            if (temp.equalsIgnoreCase("P")) {
                temp = "Photometic";
            } else if (temp.equalsIgnoreCase("T")) {
                temp = "AST";
            }
            d.setArrayCoatingMfg(temp);
            d.setArrayWavelength(configSlot[0].substring(1, 2));
            String l2 = configSlot[0].substring(2);
            d.setLensInstalled(!l2.trim().equals("0"));
            this.setCpldVersion(configSlot[1]);
        }
        if (this.isDetectorSerialNumberDefined()) {
            Detector d = this.getDetector();
            d.setSerialNumber(this.spectrometer.getInfo(this.spectrometer.getDetectorSerialNumberSlot()));
        }
        if (this.isCPLDVersionDefined() && !this.isSpectrometerConfigurationDefined()) {
            this.setCpldVersion(this.spectrometer.getInfo(this.spectrometer.getCPLDVersionSlot()));
        }
    }

    public void setConfigurationToSpectrometer() throws IOException {
        if (this.isBenchDefined()) {
            Bench b = this.getBench();
            String gratingString = "0" + b.getGrating();
            gratingString = gratingString.substring(gratingString.length() - 2, gratingString.length());
            String filterString = "00" + b.getFilterWavelength();
            filterString = filterString.substring(filterString.length() - 3, filterString.length());
            String slitString = "00" + b.getSlitSize();
            slitString = slitString.substring(slitString.length() - 3, slitString.length());
            this.spectrometer.setInfo(this.spectrometer.getBenchSlot(), gratingString + " " + filterString + " " + slitString);
        }
        if (this.isSpectrometerConfigurationDefined()) {
            Detector d = this.getDetector();
            this.spectrometer.setInfo(this.spectrometer.getSpectrometerConfigSlot(), d.getArrayCoatingMfg() + d.getArrayWavelength() + (d.isLensInstalled() ? "1" : "0") + "  " + this.getCpldVersion());
        }
        if (this.isDetectorSerialNumberDefined()) {
            this.spectrometer.setInfo(this.spectrometer.getDetectorSerialNumberSlot(), this.getDetector().getSerialNumber());
        }
        if (this.isCPLDVersionDefined() && !this.isSpectrometerConfigurationDefined()) {
            this.spectrometer.setInfo(this.spectrometer.getCPLDVersionSlot(), this.getCpldVersion());
        }
    }

    public Bench getBench() {
        return this.bench;
    }

    public void setBench(Bench value) {
        this.bench = value;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(Detector value) {
        this.detector = value;
    }

    public String getCpldVersion() {
        return this.cpldVersion;
    }

    public void setCpldVersion(String value) {
        this.cpldVersion = value;
    }

    public boolean isBenchDefined() {
        return this.spectrometer.getBenchSlot() >= 0;
    }

    public boolean isSpectrometerConfigurationDefined() {
        return this.spectrometer.getSpectrometerConfigSlot() >= 0;
    }

    public boolean isDetectorSerialNumberDefined() {
        return this.spectrometer.getDetectorSerialNumberSlot() >= 0;
    }

    public boolean isCPLDVersionDefined() {
        return this.spectrometer.getCPLDVersionSlot() >= 0;
    }

    public String toString() {
        Bench b = this.getBench();
        Detector d = this.getDetector();
        String s = "";
        if (this.isBenchDefined()) {
            s = s + "Optical Bench:\n\tGrating: " + b.getGrating() + "\n\tFilter: " + b.getFilterWavelength() + "\n\tSlit size: " + b.getSlitSize() + "\n";
        }
        if (this.isSpectrometerConfigurationDefined()) {
            s = s + "Detector:\n\tArray coating manufacturer: " + d.getArrayCoatingMfg() + "\n\tArray wavelength: " + d.getArrayWavelength() + "\n\tLens installed: " + d.isLensInstalled() + "\n\tSerial number: " + d.getSerialNumber() + "\n";
        }
        if (this.isDetectorSerialNumberDefined()) {
            s = s + "\tDetector serial number: " + d.getSerialNumber() + "\n";
        }
        s = s + "CPLD version: " + this.getCpldVersion() + "\n";
        return s;
    }
}

