/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelProvider;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000USB;
import com.oceanoptics.omnidriver.spectrometer.jaz.JazNetwork;
import com.oceanoptics.omnidriver.spectrometer.jaz.JazUSB;
import com.oceanoptics.spectralprocessing.SpectralProcessor;
import java.io.IOException;

public class SpectrometerAssembly {
    private Spectrometer spectrometer;
    private boolean[] isSaturated;
    private boolean[] isTimeout;
    private SpectrometerChannel[] channels;
    private SpectralProcessor[] spectralProcessors;
    private Spectrum[] spectrumBufferArray;
    private boolean[] isValidSpectrum;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\ncloseSpectrometer,()V\ngetNumberOfChannels,()I\nisChannelEnabled,(I)Z\ngetChannel,(I)Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;\ngetSpectralProcessor,(I)Lcom/oceanoptics/spectralprocessing/SpectralProcessor;\ngetSpectrometer,()Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;\ngetSpectrumBuffer,(I)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nisSpectrumValid,(I)Z\nsetSpectrumValidity,(IZ)V\nsetSaturationState,(IZ)V\ngetSaturationState,(I)Z\nsetTimeoutState,(IZ)V\ngetTimeoutState,(I)Z\n";

    public SpectrometerAssembly(Spectrometer spectrometerObject) throws IOException {
        this.spectrometer = spectrometerObject;
        this.channels = new SpectrometerChannel[this.spectrometer.getNumberOfChannels()];
        this.spectralProcessors = new SpectralProcessor[this.spectrometer.getNumberOfChannels()];
        this.isSaturated = new boolean[this.spectrometer.getNumberOfChannels()];
        this.isTimeout = new boolean[this.spectrometer.getNumberOfChannels()];
        this.spectrumBufferArray = new Spectrum[this.spectrometer.getNumberOfChannels()];
        this.isValidSpectrum = new boolean[this.spectrometer.getNumberOfChannels()];
        SpectrometerChannel[] ch = this.spectrometer.getChannels();
        for (int channelIndex = 0; channelIndex < this.spectrometer.getNumberOfChannels(); ++channelIndex) {
            if (this.isChannelEnabled(channelIndex)) {
                this.channels[channelIndex] = ch[channelIndex];
                this.spectralProcessors[channelIndex] = new SpectralProcessor(ch[channelIndex], false);
                this.isSaturated[channelIndex] = false;
                this.isTimeout[channelIndex] = false;
                this.isValidSpectrum[channelIndex] = false;
                this.spectrumBufferArray[channelIndex] = null;
                continue;
            }
            this.channels[channelIndex] = null;
            this.spectralProcessors[channelIndex] = null;
            this.isSaturated[channelIndex] = false;
            this.isTimeout[channelIndex] = false;
            this.isValidSpectrum[channelIndex] = false;
            this.spectrumBufferArray[channelIndex] = null;
        }
    }

    public void closeSpectrometer() {
        try {
            for (int channelIndex = 0; channelIndex < this.spectrometer.getNumberOfChannels(); ++channelIndex) {
                this.spectralProcessors[channelIndex].destroyProcessor();
            }
            this.spectrometer.closeSpectrometer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getNumberOfChannels() {
        return this.spectrometer.getNumberOfChannels();
    }

    public boolean isChannelEnabled(int channelIndex) {
        if (!(this.spectrometer instanceof USBSpectrometer)) {
            return false;
        }
        MultiChannelProvider multiChannelProvider = (MultiChannelProvider)((Object)((USBSpectrometer)this.spectrometer).getFeatureController(MultiChannelProvider.class));
        if (multiChannelProvider != null) {
            return multiChannelProvider.isChannelPresent(channelIndex);
        }
        if (this.spectrometer instanceof ADC1000USB) {
            return ((ADC1000USB)this.spectrometer).isChannelPresent(channelIndex);
        }
        if (this.spectrometer instanceof JazUSB) {
            return ((JazUSB)this.spectrometer).isChannelPresent(channelIndex);
        }
        if (this.spectrometer instanceof JazNetwork) {
            return ((JazNetwork)this.spectrometer).isChannelPresent(channelIndex);
        }
        return channelIndex == 0;
    }

    public SpectrometerChannel getChannel(int channelIndex) {
        return this.channels[channelIndex];
    }

    public SpectralProcessor getSpectralProcessor(int channelIndex) {
        return this.spectralProcessors[channelIndex];
    }

    public Spectrometer getSpectrometer() {
        return this.spectrometer;
    }

    public Spectrum getSpectrumBuffer(int channelIndex) {
        Spectrum spectrum = this.spectrumBufferArray[channelIndex];
        if (spectrum == null) {
            int numberOfPixels = this.getSpectrometer().getNumberOfPixels();
            int numberOfDarkPixels = this.getSpectrometer().getNumberOfDarkPixels();
            this.spectrumBufferArray[channelIndex] = spectrum = new Spectrum(numberOfPixels, numberOfDarkPixels);
        }
        return spectrum;
    }

    public boolean isSpectrumValid(int channelIndex) {
        return this.isValidSpectrum[channelIndex];
    }

    public void setSpectrumValidity(int channelIndex, boolean isValid) {
        this.isValidSpectrum[channelIndex] = isValid;
    }

    public void setSaturationState(int channelIndex, boolean saturationFlag) {
        this.isSaturated[channelIndex] = saturationFlag;
    }

    public boolean getSaturationState(int channelIndex) {
        return this.isSaturated[channelIndex];
    }

    public void setTimeoutState(int channelIndex, boolean timeoutFlag) {
        this.isTimeout[channelIndex] = timeoutFlag;
    }

    public boolean getTimeoutState(int channelIndex) {
        return this.isTimeout[channelIndex];
    }
}

