/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer;

import com.oceanoptics.omnidriver.constants.USBProductInfo;
import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.USBImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.RawData;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerFactory;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.uniusb.UniUSBPipeManager;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;

public abstract class USBSpectrometer
extends Spectrometer {
    protected static final int MAX_USB_DEVICES = 64;
    private static int MAX_PLUGINS = 6;
    protected SpectrometerPlugIn[] plugIn;
    protected int deviceIndex = -1;
    protected USBInterface usb;
    protected byte[] out;
    protected byte[] in;
    protected boolean timeoutOccurredFlag = false;
    protected int vendorID = 9303;
    protected int productID;
    PollingThread[] pollingThreads;
    protected HashMap featureMap = new HashMap();
    protected USBEndpointDescriptor dataOutEndPoint = null;
    protected USBEndpointDescriptor highSpeedInEndPoint1 = null;
    protected USBEndpointDescriptor highSpeedInEndPoint2 = null;
    protected USBEndpointDescriptor lowSpeedInEndPoint = null;
    private static String __extern__ = "__extern__\n<init>,()V\ngetInputBuffer,()[B\ngetOutputBuffer,()[B\nopenNextUnclaimed,()V\nopenNextUnclaimedUSB,()V\ngetOpenSpectrometersOfThisType,()[Lcom/oceanoptics/omnidriver/spectrometer/USBSpectrometer;\ninitialize,()V\nsetIntegrationTime,(I)V\nsetTimeout,(I)I\nsetStrobeEnable,(Z)V\nsetStrobeDelay,(I)V\nsetPowerState,(Z)V\ngetInfo,(I)Ljava/lang/String;\nsetInfo,(ILjava/lang/String;)V\ngetInfoBytes,(I)[B\nsetInfoBytes,(I[B)V\ngetSerialNumber,()Ljava/lang/String;\nsetSerialNumber,(Ljava/lang/String;)V\ngetStatusArray,()[B\ngetDeviceIndex,()I\ncloseSpectrometer,()V\ngetFirmwareVersion,()Ljava/lang/String;\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrumRaw,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ninitiateSpectrumAcquisition,()Z\ngetAcquiredSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetName,()Ljava/lang/String;\ngetClassName,()Ljava/lang/String;\nwriteConfigurationToFile,(Ljava/io/File;)V\ngetNumberOfPixels,(I)I\ngetNumberOfDarkPixels,(I)I\ngetNumberOfDarkCCDPixels,()I\ngetNumberOfCCDPixels,()I\nclose,()V\ngetFeatureController,(Ljava/lang/Class;)Lcom/oceanoptics/omnidriver/features/USBFeature;\nisCommunicatingSuccessfully,()Z\ntestSpectrometerCommunication,()Ljava/lang/String;\nisTimeout,()Z\ntoString,()Ljava/lang/String;\n";

    public USBSpectrometer() throws IOException {
        this.usb = new USBImpl();
        this.in = this.usb.getInputBuffer();
        this.out = this.usb.getOutputBuffer();
    }

    protected void finishConstruction() throws IOException {
        super.finishConstruction();
        this.getScoreboard()[this.deviceIndex] = this;
        this.getCoefficientsFromSpectrometer();
        this.formattingThread = new Spectrometer.FormattingThread(this.getName() + " FormattingThread");
        this.formattingThread.setDaemon(true);
        this.formattingThread.start();
        this.pollingThreads = new PollingThread[this.channels.length];
        try {
            SpectrometerPlugIn[] plugins;
            Class[] pluginClasses = null;
            if (this instanceof PlugInProvider && null != (plugins = ((PlugInProvider)((Object)this)).getPlugIns())) {
                pluginClasses = new Class[plugins.length];
                for (int i = 0; i < plugins.length; ++i) {
                    pluginClasses[i] = plugins[i].getClass();
                }
            }
            this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), pluginClasses, this.numChannels, this.getNumberOfCCDPixels(), this.getNumberOfDarkCCDPixels(), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.numChannels; ++i) {
            if (null == this.channels[i]) continue;
            this.channels[i].generateMetadata(this.spectrumBase, i);
        }
    }

    public byte[] getInputBuffer() {
        return this.in;
    }

    public byte[] getOutputBuffer() {
        return this.out;
    }

    protected abstract Spectrometer[] getScoreboard();

    public void openNextUnclaimed() throws IOException {
        this.openNextUnclaimedUSB();
    }

    public void openNextUnclaimedUSB() throws IOException {
        Spectrometer[] scoreboard = this.getScoreboard();
        for (int i = 0; i < 64; ++i) {
            if (scoreboard[i] != null) {
                try {
                    this.logger.finest("Testing if " + scoreboard[i].getName() + " at " + i + " is still open/alive.");
                    scoreboard[i].getSerialNumber();
                    continue;
                }
                catch (IOException e) {
                    try {
                        scoreboard[i].closeSpectrometer();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    scoreboard[i] = null;
                }
            }
            try {
                this.openSpectrometer(i);
            }
            catch (IOException e) {
                continue;
            }
            this.logger.finer("Found spectrometer: " + this.getName() + ", at USB Location " + i);
            scoreboard[i] = this;
            return;
        }
        this.logger.finest("No additional spectrometers of type " + this.getName() + " found.");
        throw new IOException("No additional spectrometers of type " + this.getName() + " found.");
    }

    public USBSpectrometer[] getOpenSpectrometersOfThisType() {
        Vector<Spectrometer> specs = new Vector<Spectrometer>();
        Spectrometer[] scoreboard = this.getScoreboard();
        for (int i = 0; i < scoreboard.length; ++i) {
            if (scoreboard[i] == null) continue;
            specs.add(scoreboard[i]);
        }
        return specs.toArray(new USBSpectrometer[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 1;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
            this.logger.finest("Spectrometer initialized");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegrationTime(int intTime) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            boolean needStabilityScan;
            boolean bl = needStabilityScan = this.integrationTime != intTime;
            if (!needStabilityScan) {
                this.logger.fine("Desired integration time already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int maxTime = this.getIntegrationTimeMaximum();
            int minTime = this.getIntegrationTimeMinimum();
            if (intTime < minTime) {
                intTime = minTime;
            } else if (intTime > maxTime) {
                intTime = maxTime;
            }
            this.integrationTime = intTime;
            this.out[0] = 2;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)(intTime /= this.getIntegrationTimeBase())));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)intTime));
            this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)intTime));
            this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)intTime));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 5);
            if (needStabilityScan && this.isStabilityScan()) {
                this.doStabilityScan(1);
            }
            this.logger.fine("Integration time set to: " + intTime);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setTimeout(int timeoutMilliseconds) {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int returnCode;
            try {
                returnCode = this.usb.setTimeout(this.highSpeedInEndPoint1, timeoutMilliseconds);
                if (returnCode == 1) {
                    returnCode = this.usb.setTimeout(this.highSpeedInEndPoint2, timeoutMilliseconds);
                }
                if (returnCode == 1) {
                    returnCode = this.usb.setTimeout(this.lowSpeedInEndPoint, timeoutMilliseconds);
                }
            }
            catch (IOException exception) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return -1;
            }
            return returnCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrobeEnable(boolean strobe) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (this.strobeOn == null) {
                this.strobeOn = new Boolean(strobe);
            } else if (this.strobeOn == strobe) {
                this.logger.fine("Desired strobe enable state already set, not pushing to spectrometer");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int on = !strobe ? 0 : 1;
            this.out[0] = 3;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)on));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)on));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            if (strobe != this.strobeOn && this.isStabilityScan()) {
                this.doStabilityScan(1);
            }
            this.strobeOn = strobe ? Boolean.TRUE : Boolean.FALSE;
            this.logger.fine("Strobe enabled: " + strobe);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setStrobeDelay(int delay) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerState(boolean power) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            int sd = !power ? 0 : 1;
            this.out[0] = 4;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)sd));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)sd));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 5);
            this.logger.fine("Power mode (0-off, 1 on): " + sd);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo(int slot) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int i;
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                String strRet = "";
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (i = 2; this.in[i] != 0 && i < 17; ++i) {
                    strRet = strRet + (char)this.in[i];
                }
                if (5 == slot && i < 16 && this.in[i] == 0 && this.in[i + 1] != 0) {
                    ++i;
                    strRet = strRet + " ";
                    while (this.in[i] != 0 && i < 17) {
                        strRet = strRet + (char)this.in[i];
                        ++i;
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return strRet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfo(int slot, String str) throws IOException {
        this.clearOutBuffer();
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 6;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
            try {
                byte[] bytes = str.getBytes("US-ASCII");
                for (int i = 0; i < bytes.length; ++i) {
                    this.out[2 + i] = bytes[i];
                }
            }
            catch (UnsupportedEncodingException e) {
                this.logger.severe("Error encoding configuration variables.");
                throw new IOException("Error encoding configuration variables: " + e.getMessage());
            }
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            this.logger.fine("Configuration variable written to EEPROM.");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.severe("EEPROM write might not have completed. Please verify.");
                throw new IOException("EEPROM write might not have completed. Please verify.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getInfoBytes(int slot) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] byteArray = new byte[15];
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                String strRet = "";
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (int i = 0; i < 15; ++i) {
                    byteArray[i] = this.in[i + 2];
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return byteArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfoBytes(int slot, byte[] byteArray) throws IOException {
        this.clearOutBuffer();
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 6;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
            if (byteArray.length > 15) {
                throw new IOException("Byte array longer than 15 bytes");
            }
            for (int i = 0; i < byteArray.length; ++i) {
                this.out[i + 2] = byteArray[i];
            }
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            this.logger.fine("Configuration variable written to EEPROM.");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.severe("EEPROM write might not have completed. Please verify.");
                throw new IOException("EEPROM write might not have completed. Please verify.");
            }
            return;
        }
    }

    public String getSerialNumber() throws IOException {
        String serialNumber = this.getInfo(0);
        this.logger.finest("Serial number: " + serialNumber);
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) throws IOException {
        this.setInfo(0, serialNumber);
        this.logger.fine("New serial number " + serialNumber + " written to EEPROM.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSpectrum() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.logger.finer("Spectrum requested.");
            this.out[0] = 9;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStabilityScan(int numScans) throws IOException {
        HardwareTrigger ht;
        Integer mode;
        if (this instanceof HardwareTrigger && (mode = (ht = (HardwareTrigger)((Object)this)).getExternalTriggerMode()) != null && mode == 4) {
            System.err.println("Not doing stability scan!");
            return;
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                for (int i = 0; i < numScans; ++i) {
                    this.requestSpectrum();
                    this.readSpectrum();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStatusArray() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = -2;
                byte[] b = new byte[16];
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, b, 16);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return b;
            }
        }
    }

    public int getDeviceIndex() {
        this.logger.fine("Device index: " + this.deviceIndex);
        return this.deviceIndex;
    }

    public void closeSpectrometer() throws IOException {
        this.setStrobeEnable(false);
        this.getScoreboard()[this.deviceIndex] = null;
        SpectrometerFactory.closeSpectrometer(this);
        this.usb.closeDevice();
        if (this.pollingThreads != null) {
            for (int i = 0; i < this.pollingThreads.length; ++i) {
                if (this.pollingThreads[i] == null) continue;
                this.pollingThreads[i].quit();
                this.pollingThreads[i] = null;
            }
            this.pollingThreads = null;
        }
        if (this.formattingThread != null) {
            this.formattingThread.quit();
            this.formattingThread = null;
        }
        UniUSBPipeManager.removeDeviceMapping((long)this.deviceIndex);
    }

    public String getFirmwareVersion() throws IOException {
        this.firmwareVersion = this.usb.getUSBStringDescriptor(1);
        this.parseFirmwareVersion(this.firmwareVersion);
        this.logger.fine("Firmware version: " + this.firmwareVersion);
        return this.firmwareVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.timeoutOccurredFlag = false;
                try {
                    this.requestSpectrum();
                    this.readSpectrum();
                }
                catch (IOException exception) {
                    this.timeoutOccurredFlag = this.determineWhetherTimeoutOccurred(exception);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
            {
                spectrum.setSaturated(false);
                this.formatData(this.rawData, spectrum);
                return spectrum;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrumRaw(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                try {
                    this.requestSpectrum();
                    this.readSpectrum();
                }
                catch (IOException e) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
            {
                spectrum.setSaturated(false);
                this.formatDataRaw(this.rawData, spectrum);
                return spectrum;
            }
        }
    }

    protected Spectrum formatDataRaw(byte[] data, Spectrum doubleSpectrum) throws IOException {
        return this.formatData(data, doubleSpectrum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initiateSpectrumAcquisition() {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                try {
                    this.requestSpectrum();
                }
                catch (IOException e) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getAcquiredSpectrum(Spectrum spectrum) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.readSpectrum();
                spectrum.setSaturated(false);
                this.formatData(this.rawData, spectrum);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return spectrum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum(byte[] data) throws IOException {
        byte[] byArray = data;
        synchronized (data) {
            this.usb.bulkIn(this.highSpeedInEndPoint1, data, this.pipeSize);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum() throws IOException {
        byte[] byArray = this.rawData;
        synchronized (this.rawData) {
            this.usb.bulkIn(this.highSpeedInEndPoint1, this.rawData, this.pipeSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        String str;
        try {
            str = USBProductInfo.getProductInfo((int)this.vendorID, (int)this.productID).name;
        }
        catch (NullPointerException ne) {
            str = "Simulation";
        }
        return str;
    }

    public String getClassName() {
        return USBProductInfo.getProductInfo((int)this.vendorID, (int)this.productID).name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInBuffer() {
        byte[] byArray = this.in;
        synchronized (this.in) {
            this.logger.finest("Clearing in buffer.");
            for (int i = 0; i < this.in.length; ++i) {
                this.in[i] = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearOutBuffer() {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.logger.finest("Clearing out buffer.");
            for (int i = 0; i < this.out.length; ++i) {
                this.out[i] = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void writeConfigurationToFile(File file) {
    }

    public int getNumberOfPixels(int index) {
        return this.channels[index].getNumberOfPixels();
    }

    public int getNumberOfDarkPixels(int index) {
        return this.channels[index].getNumberOfDarkPixels();
    }

    public int getNumberOfDarkCCDPixels() {
        return this.numberOfDarkCCDPixels;
    }

    public int getNumberOfCCDPixels() {
        return this.numberOfCCDPixels;
    }

    public void close() throws IOException {
        if (this.pollingThreads != null) {
            for (int i = 0; i < this.pollingThreads.length; ++i) {
                if (this.pollingThreads[i] == null) continue;
                this.pollingThreads[i].quit();
                this.pollingThreads[i] = null;
            }
            this.pollingThreads = null;
        }
        if (this.formattingThread != null) {
            this.formattingThread.quit();
            this.formattingThread = null;
        }
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closeSpectrometer();
    }

    synchronized long getPollingInterval(int index) {
        PollingThread pollingThread = this.pollingThreads[index];
        if (pollingThread == null) {
            return -1L;
        }
        return pollingThread.getPollingInterval();
    }

    synchronized void setPollingInterval(int index, long pollingInterval) {
        PollingThread pollingThread = this.pollingThreads[index];
        if (pollingThread == null) {
            this.pollingThreads[index] = pollingThread = new PollingThread(this.getName() + " channel " + index + " PollingThread", index);
        }
        long originalInterval = pollingThread.getPollingInterval();
        pollingThread.setPollingInterval(pollingInterval);
        if (originalInterval < 0L && pollingInterval >= 0L) {
            pollingThread.setDaemon(true);
            pollingThread.setPriority(7);
            pollingThread.start();
        } else if (originalInterval >= 0L && pollingInterval < 0L) {
            pollingThread.quit();
        }
    }

    public USBFeature getFeatureController(Class myClass) {
        return (USBFeature)this.featureMap.get(myClass);
    }

    public boolean isCommunicatingSuccessfully() {
        try {
            this.testSpectrometerCommunication();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String testSpectrometerCommunication() throws IOException {
        int i;
        String s = null;
        if (this.deviceIndex < 0) {
            return "Unopened " + USBProductInfo.getProductInfo((int)this.vendorID, (int)this.productID).name;
        }
        s = this.getName() + "\n\tSerial number: " + this.getSerialNumber() + "\n\tFirmware version: " + this.getFirmwareVersion() + "\n";
        for (i = 0; i < this.numChannels; ++i) {
            if (this.channels[i] == null) continue;
            s = s + "\nChannel " + i + " Coefficients:\n" + this.channels[i].getCoefficients();
        }
        s = s + "\nConfiguration:\n" + this.configuration;
        if (this.plugIn != null) {
            for (i = 0; i < this.plugIn.length; ++i) {
                if (this.plugIn[i] == null) continue;
                s = s + this.plugIn[i].toString();
            }
        }
        return s;
    }

    protected boolean determineWhetherTimeoutOccurred(Exception exception) {
        return exception.getMessage().indexOf("cause:timeout") != -1;
    }

    public boolean isTimeout() {
        return this.timeoutOccurredFlag;
    }

    public String toString() {
        String s = null;
        if (this.deviceIndex < 0) {
            return "Unopened " + USBProductInfo.getProductInfo((int)this.vendorID, (int)this.productID).name;
        }
        try {
            s = this.getName() + "\n\tSerial number: " + this.getSerialNumber() + "\n\tFirmware version: " + this.getFirmwareVersion() + "\n";
            for (int i = 0; i < this.numChannels; ++i) {
                if (this.channels[i] == null) continue;
                s = s + "\nChannel " + i + " Coefficients:\n" + this.channels[i].getCoefficients();
            }
            s = s + "\nConfiguration:\n" + this.configuration;
        }
        catch (IOException e) {
            this.logger.warning("Spectrometer: error getting spectrometer info.");
            e.printStackTrace();
            return e.getMessage();
        }
        return s;
    }

    protected class PollingThread
    extends Thread {
        private boolean quit;
        private int channel;
        private long pollingInterval;

        public PollingThread(String name, int index) {
            super(name);
            this.pollingInterval = -1L;
            this.channel = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.quit) {
                try {
                    long startTime;
                    RawData rawData = new RawData(USBSpectrometer.this.pipeSize);
                    Object object = this;
                    synchronized (object) {
                        USBSpectrometer.this.requestSpectrum();
                        startTime = System.currentTimeMillis();
                        USBSpectrometer.this.readSpectrum(rawData.getData());
                        rawData.setEndTime(System.currentTimeMillis());
                    }
                    rawData.setStartTime(startTime);
                    rawData.setRequestingChannel(this.channel);
                    object = USBSpectrometer.this.formattingQueue;
                    synchronized (object) {
                        USBSpectrometer.this.formattingQueue.add(rawData);
                        USBSpectrometer.this.formattingQueue.notify();
                    }
                    long sleepTime = startTime + this.pollingInterval - System.currentTimeMillis();
                    if (sleepTime <= 0L) continue;
                    try {
                        Thread.currentThread();
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                    }
                }
                catch (IOException e) {
                    USBSpectrometer.this.logger.warning("IOException in " + this.getName());
                    System.out.print("E");
                    System.out.flush();
                }
            }
        }

        public void quit() {
            this.quit = true;
            this.interrupt();
        }

        public long getPollingInterval() {
            return this.pollingInterval;
        }

        public void setPollingInterval(long pollingInterval) {
            if (pollingInterval < 0L) {
                throw new IllegalArgumentException("Polling interval must be >= 0.");
            }
            this.pollingInterval = pollingInterval;
        }
    }
}

