/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.adc1000usb;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.analogout.AnalogOut;
import com.oceanoptics.omnidriver.features.analogout.AnalogOutGUIProvider;
import com.oceanoptics.omnidriver.features.analogout.AnalogOutImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_ADC1000;
import com.oceanoptics.omnidriver.features.errorprovider.DeepWellErrorProvider;
import com.oceanoptics.omnidriver.features.errorprovider.DeepWellErrorProviderImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplNonFPGA;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRate;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl_ADC;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelGUIProvider;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelImpl;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelListener;
import com.oceanoptics.omnidriver.features.multichannelprovider.MultiChannelProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.AcquisitionPropertiesListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.OmniDriverDispatchListener;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000Channel;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class ADC1000USB
extends USBSpectrometer
implements AnalogOut,
ContinuousStrobe,
HardwareTrigger,
MasterClockRate,
MultiChannelProvider,
NonlinearityCorrectionProvider,
StrayLightCorrection,
WavelengthCalibrationProvider,
Version,
DeepWellErrorProvider,
USBEndpointDevice {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private final int CHANNELS_ENABLED = 1;
    private final int NUM_DAC_PINS = 8;
    private boolean deepWell = false;
    public static final byte DW_INFO_SLOT = 42;
    private int numberOfEnabledChannels;
    private int deepWellMinIntegrationTime;
    private int minIntegrationTimeHolder;
    private AnalogOutGUIProvider analogOut;
    private ContinuousStrobeGUIProvider continuousStrobe;
    private HardwareTriggerImpl hardwareTrigger;
    private MasterClockRate masterClockRate;
    private MultiChannelGUIProvider multiChannel;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private StrayLightCorrectionGUIProvider straylight;
    private WavelengthCalibrationGUIProvider wavelength;
    private VersionGUIProvider version;
    private DeepWellErrorProviderImpl deepWellError;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,(I)V\n<init>,()V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nallowWriteToEEPROM,(II)Z\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrum,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nsetCoefficients,()V\ngetDeepWellMinimumIntegrationTime,()I\naddOmniDriverDispatchListener,(Lcom/oceanoptics/omnidriver/interfaces/OmniDriverDispatchListener;)V\nremoveOmniDriverDispatchListener,(Lcom/oceanoptics/omnidriver/interfaces/OmniDriverDispatchListener;)V\naddAcquisitionPropertiesListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionPropertiesListener;)V\nremoveAcquisitionPropertiesListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionPropertiesListener;)V\ngetActualIntegrationTime,()I\nreadStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\ngetNewCoefficients,(I)Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nisDeepWell,()Z\nsetDeepWell,(Z)V\nsetIntegrationTime,(I)V\nsetStrobeDelay,(I)V\ngetNumberOfChannels,()I\ngetChannelsPresent,()[Z\ngetNumberOfEnabledChannels,()I\nsetChannelMux,(I)V\nsetChannelPresent,(IZ)V\nisChannelPresent,(I)Z\nsetChannels,([Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;)V\nsetChannelStatus,(IZ)V\nsetDeepWellStatus,(Z)V\ngetChannelIndices,()[I\nisRotatorEnabled,()Z\nsetRotatorEnabled,(Z)V\nisInterpolationEnabled,()Z\nsetInterpolationEnabled,(Z)V\naddChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nremoveChannelListener,(Lcom/oceanoptics/omnidriver/features/multichannelprovider/MultiChannelListener;)V\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\ncontinuousStrobeCountsToMicros,(I)D\nsetMasterClock,(I)V\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nsetDACCounts,(II)V\nanalogOutCountsToVolts,(I)D\ngetDACMinimum,()I\ngetDACMaximum,()I\ngetDACIncrement,()I\ngetDACCounts,(I)Ljava/lang/Integer;\nisDACPresent,()Z\ngetDACPins,()I\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public ADC1000USB(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    public ADC1000USB() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public boolean allowWriteToEEPROM(int privilegeLevel, int slot) {
        if (slot < 0) {
            return false;
        }
        if (privilegeLevel == 0) {
            return true;
        }
        if (privilegeLevel == 1) {
            if (slot == 0) {
                return false;
            }
            return slot <= 44;
        }
        return false;
    }

    public void openSpectrometer(int index) throws IOException {
        this.minIntegrationTimeHolder = this.integrationTimeMinimum = 3000;
        this.deepWellMinIntegrationTime = 35000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 4095;
        this.pipeSize = this.numberOfCCDPixels * 2 + 1;
        this.rawData = new byte[this.pipeSize];
        this.cpldVersionSlot = 44;
        this.numChannels = 8;
        this.rotatorEnabled = false;
        this.productID = 4100;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        super.initialize();
        this.readSpectrum();
        super.getFirmwareVersion();
        this.multiChannel = new MultiChannelImpl(this.usb, this, this.numChannels);
        this.setChannelMux(0);
        this.configuration = new Configuration(this);
        this.channels = new ADC1000Channel[this.numChannels];
        this.channels = this.discoverChannels();
        this.initUSBFeatures(this.usb);
        this.logger.fine("ADC1000-USB has been opened at index " + index);
        try {
            super.finishConstruction();
        }
        catch (IOException e) {
            System.out.println("died in ADC1000-USB line 283 - finishConstruction()");
        }
    }

    private SpectrometerChannel[] discoverChannels() throws IOException {
        int deepWellStatus = 0;
        try {
            deepWellStatus = Integer.parseInt(super.getInfo(42));
        }
        catch (NumberFormatException ne) {
            deepWellStatus = 0;
        }
        if (deepWellStatus > 0 || this.getSerialNumber().substring(0, 2).equalsIgnoreCase("DW")) {
            this.setDeepWell(true);
        } else {
            this.setDeepWell(false);
        }
        int channelVector = Integer.parseInt(super.getInfo(1));
        for (int i = 0; i < this.channels.length; ++i) {
            if ((channelVector >> i & 1) != 0) {
                this.channels[i] = new ADC1000Channel(this, new Coefficients(), i);
                this.multiChannel.setChannelStatus(i, true);
            } else {
                this.multiChannel.setChannelStatus(i, false);
            }
            this.enabledChannels = ++this.numberOfEnabledChannels;
        }
        this.multiChannel.setChannels(this.channels);
        return this.channels;
    }

    private void initUSBFeatures(USBInterface usb) {
        this.continuousStrobe = new ContinuousStrobeImpl_ADC1000(usb);
        this.masterClockRate = new MasterClockRateImpl_ADC(usb);
        this.hardwareTrigger = new HardwareTriggerImplNonFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(2), new ExternalTriggerMode(3)});
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.deepWellError = new DeepWellErrorProviderImpl(usb, this);
        this.deepWellError.setIgnore(!this.isDeepWell());
        this.featureMap.put(ContinuousStrobeImpl.class, (ContinuousStrobeImpl)this.continuousStrobe);
        this.featureMap.put(AnalogOutImpl.class, (AnalogOutImpl)this.analogOut);
        this.featureMap.put(MasterClockRateImpl.class, (MasterClockRateImpl)this.masterClockRate);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
        this.featureMap.put(DeepWellErrorProviderImpl.class, this.deepWellError);
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.wavelength);
        features.add(this.straylight);
        features.add(this.nonlinearity);
        features.add(this.multiChannel);
        features.add(this.continuousStrobe);
        features.add(this.hardwareTrigger);
        try {
            if (this.isDACPresent()) {
                features.add(this.analogOut);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        features.add(this.version);
        return features.toArray(new GUIProvider[0]);
    }

    protected Spectrum formatData(byte[] data, Spectrum spectrum) throws IOException {
        this.logger.finest("Formatting spectrum...");
        spectrum.setSaturated(false);
        double[] spectrumArray = spectrum.getSpectrum();
        byte zero = 0;
        if (data[this.numberOfCCDPixels * 2] != 105) {
            this.logger.severe("Lost synchronization");
            throw new IOException("Lost synchronization");
        }
        for (int i = spectrumArray.length - 1; i >= 0; --i) {
            int LSBPacket = i >> 6;
            int MSBPacket = LSBPacket + 1;
            byte MSB = data[(MSBPacket << 6) + i];
            byte LSB = data[(LSBPacket << 6) + i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) & 0xFFF;
            if (pixel >= this.maxIntensity) {
                spectrum.setSaturated(true);
            }
            spectrumArray[i] = pixel;
        }
        return spectrum;
    }

    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        block15: {
            this.logger.finest("Getting 0...");
            this.timeoutOccurredFlag = false;
            try {
                if (!this.rotatorEnabled && !this.deepWell) {
                    return super.getSpectrum(spectrum);
                }
                if (this.deepWell) {
                    Spectrum cdsSpectrum = new Spectrum(this.numberOfCCDPixels, 0);
                    cdsSpectrum = super.getSpectrum(cdsSpectrum);
                    double[] cspec = cdsSpectrum.getSpectrum();
                    double[] tspec = new double[this.numberOfPixels];
                    int j = 2;
                    for (int i = 1; i < this.numberOfPixels; ++i) {
                        tspec[i] = cspec[j] - cspec[j + 1];
                        j += 2;
                    }
                    spectrum.setSpectrum(tspec);
                    return spectrum;
                }
                if (!this.rotatorEnabled) break block15;
                if (this.tempSpectrum == null) {
                    this.tempSpectrum = new Spectrum(this.numberOfCCDPixels, 0);
                }
                this.tempSpectrum = super.getSpectrum(spectrum);
                this.numberOfEnabledChannels = this.getNumberOfEnabledChannels();
                int channelOffset = 0;
                for (int c = 0; c < this.numChannels; ++c) {
                    ADC1000Channel channel = (ADC1000Channel)this.channels[c];
                    if (channel == null || !channel.isEnabled()) continue;
                    Spectrum cspectrum = channel.getUnfilledSpectrum();
                    double[] cspec = cspectrum.getSpectrum();
                    double[] tspec = this.tempSpectrum.getSpectrum();
                    if (channel.isInterpolated()) {
                        int i;
                        int numberOfFullRotations = (tspec.length - c) / this.numberOfEnabledChannels;
                        int endPartialRotation = (numberOfFullRotations - 1) * this.numberOfEnabledChannels + c;
                        for (i = 0; i < c; ++i) {
                            cspec[i] = tspec[c];
                        }
                        for (i = endPartialRotation; i < tspec.length - c; ++i) {
                            cspec[i] = tspec[endPartialRotation];
                        }
                        for (i = c; i < endPartialRotation; i += this.numberOfEnabledChannels) {
                            double a = tspec[i];
                            double b = tspec[i + this.numberOfEnabledChannels];
                            double increment = (b - a) / (double)this.numberOfEnabledChannels;
                            cspec[i] = a;
                            for (int j = 1; j < this.numberOfEnabledChannels; ++j) {
                                cspec[i + j] = a += increment;
                            }
                        }
                    } else {
                        int i = 0;
                        int j = channelOffset;
                        while (i < cspec.length) {
                            cspec[i] = tspec[j];
                            ++i;
                            j += this.numberOfEnabledChannels;
                        }
                    }
                    channel.newSpectrum(cspectrum);
                    ++channelOffset;
                }
                spectrum = null;
                return null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            catch (IOException exception) {
                this.timeoutOccurredFlag = this.determineWhetherTimeoutOccurred(exception);
                throw exception;
            }
        }
        return spectrum;
    }

    public Spectrum getSpectrum() throws IOException {
        Spectrum spectrum = this.rotatorEnabled ? null : new Spectrum(this.numberOfCCDPixels, 0);
        return this.getSpectrum(spectrum);
    }

    protected void fireSpectrumToChannel(int channel, Spectrum spectrum) {
        this.channels[channel].newSpectrum(spectrum);
    }

    public void setCoefficients() throws IOException {
        boolean[] c = this.multiChannel.getChannelsPresent();
        for (int i = 0; i < this.channels.length; ++i) {
            if (!c[i]) continue;
            this.channels[i].setCoefficients();
        }
    }

    public int getDeepWellMinimumIntegrationTime() {
        return this.deepWellMinIntegrationTime;
    }

    public void addOmniDriverDispatchListener(OmniDriverDispatchListener listener) {
        this.deepWellError.addOmniDriverDispatchListener(listener);
    }

    public void removeOmniDriverDispatchListener(OmniDriverDispatchListener listener) {
        this.deepWellError.removeOmniDriverDispatchListener(listener);
    }

    public void addAcquisitionPropertiesListener(AcquisitionPropertiesListener listener) {
        this.deepWellError.addAcquisitionPropertiesListener(listener);
    }

    public void removeAcquisitionPropertiesListener(AcquisitionPropertiesListener listener) {
        this.deepWellError.removeAcquisitionPropertiesListener(listener);
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime() * 1024 / 1000;
    }

    public SpectrometerStatus readStatus() {
        return null;
    }

    public Coefficients getNewCoefficients(int index) {
        Coefficients c = new Coefficients();
        try {
            c.setWlCoefficients(this.getWavelengths(index));
            c.setStrayLight(this.getStrayLight(index));
            c.setNlCoefficients(this.getNonlinearityCoefficientsSingleChannel(index));
        }
        catch (NullPointerException ne) {
            return c;
        }
        return c;
    }

    public boolean isDeepWell() {
        return this.deepWell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeepWell(boolean dw) throws IOException {
        int rate = 1000;
        if (dw) {
            this.minIntegrationTimeHolder = this.integrationTimeMinimum;
            this.integrationTimeMinimum = this.deepWellMinIntegrationTime;
            this.numberOfPixels = 1024;
            this.numberOfDarkPixels = 0;
            rate = 90;
            if (this.deepWellError != null) {
                this.deepWellError.setIgnore(false);
                this.deepWellError.fireAcquisitionPropertiesListener();
            }
        } else {
            this.integrationTimeMinimum = this.minIntegrationTimeHolder;
            this.numberOfPixels = 2048;
            this.numberOfDarkPixels = 24;
            rate = 1000;
            if (this.deepWellError != null) {
                this.deepWellError.setIgnore(true);
                this.deepWellError.fireAcquisitionPropertiesListener();
            }
        }
        this.deepWell = dw;
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 13;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)rate));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)rate));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] == null) continue;
                ((ADC1000Channel)this.channels[i]).fixNumberOfPixels();
            }
            return;
        }
    }

    public void setIntegrationTime(int intTime) throws IOException {
        this.deepWellError.checkIntegrationTime(intTime);
        if (intTime < this.deepWellMinIntegrationTime && this.deepWellError.isInDeepWellMode()) {
            intTime = this.deepWellMinIntegrationTime;
        }
        super.setIntegrationTime(intTime);
    }

    public void setStrobeDelay(int delay) throws IOException {
        this.setContinuousStrobeDelay(delay);
    }

    public int getNumberOfChannels() {
        return this.multiChannel.getNumberOfChannels();
    }

    public boolean[] getChannelsPresent() {
        return this.multiChannel.getChannelsPresent();
    }

    public int getNumberOfEnabledChannels() {
        this.numberOfEnabledChannels = this.multiChannel.getNumberOfEnabledChannels();
        return this.numberOfEnabledChannels;
    }

    public void setChannelMux(int index) throws IOException {
        this.multiChannel.setChannelMux(index);
    }

    public void setChannelPresent(int index, boolean present) throws IOException {
        this.multiChannel.setChannelPresent(index, present);
    }

    public boolean isChannelPresent(int index) {
        return this.multiChannel.isChannelPresent(index);
    }

    public void setChannels(SpectrometerChannel[] chans) {
        this.multiChannel.setChannels(chans);
    }

    public void setChannelStatus(int index, boolean status) {
        this.multiChannel.setChannelStatus(index, status);
    }

    public void setDeepWellStatus(boolean status) throws IOException {
        this.multiChannel.setDeepWellStatus(status);
    }

    public int[] getChannelIndices() {
        return this.multiChannel.getChannelIndices();
    }

    public boolean isRotatorEnabled() {
        return this.multiChannel.isRotatorEnabled();
    }

    public void setRotatorEnabled(boolean enabled) {
        this.multiChannel.setRotatorEnabled(enabled);
    }

    public boolean isInterpolationEnabled() {
        return this.multiChannel.isInterpolationEnabled();
    }

    public void setInterpolationEnabled(boolean enabled) {
        this.multiChannel.setInterpolationEnabled(enabled);
    }

    public void addChannelListener(MultiChannelListener listener) {
        this.multiChannel.addChannelListener(listener);
    }

    public void removeChannelListener(MultiChannelListener listener) {
        this.multiChannel.removeChannelListener(listener);
    }

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(delayMicros);
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public void setMasterClock(int rate) throws IOException {
        this.masterClockRate.setMasterClock(rate);
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public void setDACCounts(int counts, int index) throws IOException {
        this.analogOut.setDACCounts(counts, index);
    }

    public double analogOutCountsToVolts(int counts) {
        return this.analogOut.analogOutCountsToVolts(counts);
    }

    public int getDACMinimum() {
        return this.analogOut.getDACMinimum();
    }

    public int getDACMaximum() {
        return this.analogOut.getDACMaximum();
    }

    public int getDACIncrement() {
        return this.analogOut.getDACIncrement();
    }

    public Integer getDACCounts(int index) {
        return this.analogOut.getDACCounts(index);
    }

    public boolean isDACPresent() throws IOException {
        return this.analogOut.isDACPresent();
    }

    public int getDACPins() {
        return this.analogOut.getDACPins();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

