/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.dragon;

import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalGUIProvider;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl_Dragon;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.statusprovider.StatusProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.spam.numericalmethods.NumericalMethods;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import com.oceanoptics.utilities.DoubleArrayManipulation;
import java.io.File;
import java.io.IOException;

public class Dragon
extends USBSpectrometer
implements StatusProvider,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
Version,
USBEndpointDevice {
    public static final int EEPROM_DELAY = 200;
    private static final int BAD_PIXELS_SLOT = 17;
    private static final int TOTAL_PIXELS = 2048;
    private static final int FINE_PIXELS = 3865;
    private static final double WAVELENGTH_STEP = 1.75;
    private static final double FINE_WAVELENGTH_STEP = 0.25;
    private static final int NUMBER_OF_PIXELS = 315;
    private double[] actualWavelength = new double[2048];
    private double[] actualIntensity = new double[2048];
    private double[] fineWavelength = new double[3865];
    private double[] interpolatedWavelength = new double[315];
    private double[] interpolatedIntensity = new double[315];
    protected BadPixelRemovalGUIProvider badPixelRemoval = null;
    private int[] badPixels;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    NumericalMethods nm = new NumericalMethods();
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationGUIProvider wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private VersionGUIProvider version;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\ngetNumberOfPixels,()I\ngetNumberOfRawPixels,()I\ngetNumberOfDarkPixels,()I\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nopenSpectrometer,(I)V\ngetChannels,()[Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\ntoString,()Ljava/lang/String;\ngetActualIntegrationTime,()I\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public Dragon() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Dragon(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public int getNumberOfPixels() {
        return 315;
    }

    public int getNumberOfRawPixels() {
        return 2048;
    }

    public int getNumberOfDarkPixels() {
        return 0;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public void openSpectrometer(int index) throws IOException {
        int i;
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 315;
        this.numberOfDarkCCDPixels = 0;
        this.maxIntensity = 4095;
        this.pipeSize = 4097;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 4156;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine("Dragon has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new Configuration(this);
        Coefficients coef = new Coefficients(this.channels[0].getCoefficients());
        this.channels[this.channelIndex].generateMetadata(this.spectrumBase, this.channelIndex);
        for (i = 0; i < 2048; ++i) {
            double dp = i;
            this.actualWavelength[i] = coef.getWlIntercept() + dp * coef.getWlFirst() + dp * dp * coef.getWlSecond() + dp * dp * dp * coef.getWlThird();
        }
        coef.setWlIntercept(350.0);
        coef.setWlFirst(1.75);
        coef.setWlSecond(0.0);
        coef.setWlThird(0.0);
        this.numberOfCCDPixels = 315;
        this.channels[0].setCoefficients(coef);
        this.channels[this.channelIndex].generateMetadata(this.spectrumBase, this.channelIndex);
        for (i = 0; i < 315; ++i) {
            this.interpolatedWavelength[i] = 350.0 + (double)i * 1.75;
        }
        for (i = 0; i < 3865; ++i) {
            this.fineWavelength[i] = 349.0 + (double)i * 0.25;
        }
        this.badPixels = this.getBadPixelsFromDevice();
        this.actualWavelength = DoubleArrayManipulation.removeElements((double[])this.actualWavelength, (int[])this.badPixels);
        this.logger.fine("Dragon has been opened");
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].generateMetadata(this.spectrumBase, i);
        }
    }

    public SpectrometerChannel[] getChannels() {
        this.logger.fine("Channels: " + this.channels);
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int[] getBadPixelsFromDevice() {
        String strBadPixels;
        byte[] inarray = new byte[256];
        try {
            strBadPixels = super.getInfo(17);
            for (int i = 0; i < 4; ++i) {
                byte[] byArray = this.out;
                // MONITORENTER : this.out
                this.out[0] = 109;
                this.out[1] = (byte)(i * 64);
                this.out[2] = 0;
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                byArray = this.in;
                // MONITORENTER : this.in
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 64);
                System.arraycopy(this.in, 0, inarray, 64 * i, 64);
                // MONITOREXIT : byArray
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        int[] pix = null;
        try {
            int numBadPixels = Integer.parseInt(strBadPixels);
            if (numBadPixels <= 0) return pix;
            pix = new int[Integer.parseInt(strBadPixels)];
            int i = 0;
            while (i < numBadPixels) {
                pix[i] = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)inarray[2 * i + 1], (byte)inarray[2 * i]);
                ++i;
            }
            return pix;
        }
        catch (NumberFormatException nfe) {
            return new int[0];
        }
    }

    protected void finishConstruction() throws IOException {
        this.numberOfPixels = this.numberOfCCDPixels;
        this.numberOfDarkPixels = this.numberOfDarkCCDPixels;
        this.getScoreboard()[this.deviceIndex] = this;
        this.getCoefficientsFromSpectrometer();
        try {
            SpectrometerPlugIn[] plugins;
            Class[] pluginClasses = null;
            if (this instanceof PlugInProvider && null != (plugins = ((PlugInProvider)((Object)this)).getPlugIns())) {
                pluginClasses = new Class[plugins.length];
                for (int i = 0; i < plugins.length; ++i) {
                    pluginClasses[i] = plugins[i].getClass();
                }
            }
            this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), pluginClasses, this.numChannels, this.getNumberOfPixels(0), this.getNumberOfDarkPixels(0), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        try {
            this.logger.finest("Formatting spectrum...");
            doubleSpectrum.setSaturated(false);
            double[] spectrum = doubleSpectrum.getSpectrum();
            byte zero = 0;
            if (data[4096] != 105) {
                this.logger.severe("Lost synchronization");
                throw new IOException("Lost synchronization");
            }
            this.actualIntensity = new double[2048];
            for (int i = 0; i < this.actualIntensity.length; ++i) {
                int LSBPacket = i >> 6;
                int MSBPacket = LSBPacket + 1;
                byte MSB = data[(MSBPacket << 6) + i];
                byte LSB = data[(LSBPacket << 6) + i];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                this.actualIntensity[i] = pixel;
            }
            this.actualIntensity = DoubleArrayManipulation.removeElements((double[])this.actualIntensity, (int[])this.badPixels);
            this.interpolateSpectrum();
            doubleSpectrum.setSpectrum(this.interpolatedIntensity);
        }
        catch (Exception e) {
            System.err.println("exception in format data");
        }
        return doubleSpectrum;
    }

    protected Spectrum formatDataRaw(byte[] data, Spectrum doubleSpectrum) throws IOException {
        try {
            this.logger.finest("Formatting spectrum...");
            doubleSpectrum.setSaturated(false);
            byte zero = 0;
            if (data[4096] != 105) {
                this.logger.severe("Lost synchronization");
                throw new IOException("Lost synchronization");
            }
            this.actualIntensity = new double[2048];
            for (int i = 0; i < this.actualIntensity.length; ++i) {
                int LSBPacket = i >> 6;
                int MSBPacket = LSBPacket + 1;
                byte MSB = data[(MSBPacket << 6) + i];
                byte LSB = data[(LSBPacket << 6) + i];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                this.actualIntensity[i] = pixel;
            }
            doubleSpectrum.setSpectrum(this.actualIntensity);
        }
        catch (Exception e) {
            System.err.println("exception in formatDataRaw()");
        }
        return doubleSpectrum;
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.badPixelRemoval = new BadPixelRemovalImpl_Dragon(usb, this, this.numberOfCCDPixels);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
        this.featureMap.put(BadPixelRemovalImpl.class, (BadPixelRemovalImpl)this.badPixelRemoval);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.straylight, this.nonlinearity, this.version};
    }

    private int[] getInvalidPixels() throws IOException {
        return this.badPixels;
    }

    private double[] interpolateSpectrum() throws IOException {
        this.interpolatedIntensity = this.nm.cubicSpline(this.actualWavelength, this.actualIntensity, this.interpolatedWavelength);
        return this.interpolatedIntensity;
    }

    public SpectrometerStatus getStatus() throws IOException {
        byte[] sb = this.getStatusArray();
        SpectrometerStatus stat = new SpectrometerStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[0], (byte)sb[1]);
        stat.integrationTime = ByteRoutines.makeWord((byte)sb[2], (byte)sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7] == 0 ? 16 : 8;
        stat.dataReady = sb[8] != 0;
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        SpectrometerStatus stat = this.getStatus();
        return stat.integrationTime;
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime() * 1024 / 1000;
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

