/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.features.laser;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.laser.LaserGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.Laser;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanSpectrometer;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.Vector;

public class LaserProviderImpl
extends USBFeature
implements LaserGUIProvider {
    private MMSRamanSpectrometer spectrometer;
    protected Laser[] lasers;
    private int numberOfSupportedLasers;
    private boolean laserTemperatureRegulation;
    protected int minimumLaserSetpoint;
    protected int maximumLaserSetpoint;
    private int laserPower;
    private int minimumLaserPowerSetpoint;
    private int maximumLaserPowerSetpoint;
    private boolean laserPowerRegulation;
    private int defaultLaser = 0;
    protected String featurePath = "mmsraman.laser.LaserPanel";
    protected String featurePath1 = "mmsraman.laser.LaserPowerPanel";
    protected String featurePath2 = "mmsraman.laser.LaserTemperaturePanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanSpectrometer;)V\ngetLaser,(I)Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;\ngetLasers,()[Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;\nsetLasers,([Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/Laser;)V\ngetNumberOfEnabledLasers,()I\ngetNumberOfSupportedLasers,()I\nsetNumberOfSupportedLasers,(I)V\ngetLaserInfo,(I)V\nsetLaserInfo,(I)V\ngetDefaultLaser,()I\nsetDefaultLaser,(I)V\nsetLaserTemperatureRegulation,(Z)V\ngetLaserTemperatureInfo,()V\nsetLaserTemperatureInfo,()V\nisLaserTemperatureRegulation,()Z\ngetMinimumLaserSetpoint,()I\nsetMinimumLaserSetpoint,(I)V\ngetMaximumLaserSetpoint,()I\nsetMaximumLaserSetpoint,(I)V\nsetLaserPowerRegulation,(Z)V\ngetLaserPowerInfo,()I\nsetLaserPowerInfo,(I)V\nisLaserPowerRegulation,()Z\ngetMinimumLaserPowerSetpoint,()I\nsetMinimumLaserPowerSetpoint,(I)V\ngetMaximumLaserPowerSetpoint,()I\nsetMaximumLaserPowerSetpoint,(I)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public LaserProviderImpl(USBInterface usbInt, MMSRamanSpectrometer spec) throws IOException {
        super(usbInt);
        this.spectrometer = spec;
    }

    public Laser getLaser(int laserIndex) {
        return this.lasers[laserIndex];
    }

    public Laser[] getLasers() {
        return this.lasers;
    }

    public void setLasers(Laser[] lasers) {
        this.lasers = lasers;
    }

    public int getNumberOfEnabledLasers() {
        int num = 0;
        for (int i = 0; i < this.lasers.length; ++i) {
            if (this.lasers[i] == null) continue;
            ++num;
        }
        return num;
    }

    private void createLasers() {
        this.lasers = new Laser[this.numberOfSupportedLasers];
    }

    private void createNewLasers(int numLasers) {
        Laser[] temp = new Laser[this.numberOfSupportedLasers + numLasers];
        System.arraycopy(this.lasers, 0, temp, 0, this.lasers.length);
        this.lasers = temp;
    }

    public int getNumberOfSupportedLasers() {
        return this.numberOfSupportedLasers;
    }

    public void setNumberOfSupportedLasers(int numLasers) {
        if (this.lasers == null) {
            this.createLasers();
        } else if (numLasers > this.numberOfSupportedLasers) {
            this.createNewLasers(numLasers - this.numberOfSupportedLasers);
        } else if (numLasers < this.numberOfSupportedLasers) {
            for (int i = this.numberOfSupportedLasers; i > numLasers; --i) {
                this.lasers[i] = null;
            }
        }
        this.numberOfSupportedLasers = numLasers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLaserInfo(int laserIndex) throws IOException {
        Laser laser = this.lasers[laserIndex];
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[6] = (byte)(laserIndex + 1);
                byte[] in = this.spectrometer.process((byte)32, 7);
                laser.setRemoteEnabled(in[7] == 1);
                int bits = ByteRoutines.makeDWordLE((byte)in[8], (byte)in[9], (byte)in[10], (byte)in[11]);
                float f = Float.intBitsToFloat(bits);
                if (new Float(f).equals(new Float(Double.NaN))) {
                    System.out.println("Need to load Laser value.");
                    this.logger.warning("Need to load Laser value.");
                } else {
                    laser.setLaserWavelength(f, 0);
                }
                laser.setSafetyKeyOn(in[12] == 1);
                laser.setLaserPresent(in[13] == 1);
                laser.setLaserFault(in[14] == 1);
                laser.setLaserTemperatureLock(in[15] == 1);
                laser.setLaserPowered(in[16] == 1);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLaserInfo(int laserIndex) throws IOException {
        Laser laser = this.lasers[laserIndex];
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[6] = (byte)(laserIndex + 1);
                this.out[7] = laser.isRemoteEnabled() ? (byte)1 : 0;
                this.out[8] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(laser.getLaserWavelength())));
                this.out[9] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(laser.getLaserWavelength())));
                this.out[10] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(laser.getLaserWavelength())));
                this.out[11] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(laser.getLaserWavelength())));
                this.spectrometer.process((byte)33, 12);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public int getDefaultLaser() {
        return this.defaultLaser;
    }

    public void setDefaultLaser(int defaultLaser) {
        this.defaultLaser = defaultLaser;
    }

    public void setLaserTemperatureRegulation(boolean laserTemperatureRegulation) {
        this.laserTemperatureRegulation = laserTemperatureRegulation;
    }

    public void getLaserTemperatureInfo() {
    }

    public void setLaserTemperatureInfo() {
    }

    public boolean isLaserTemperatureRegulation() {
        return this.laserTemperatureRegulation;
    }

    public int getMinimumLaserSetpoint() {
        return this.minimumLaserSetpoint;
    }

    public void setMinimumLaserSetpoint(int minimumLaserSetpoint) {
        this.minimumLaserSetpoint = minimumLaserSetpoint;
    }

    public int getMaximumLaserSetpoint() {
        return this.maximumLaserSetpoint;
    }

    public void setMaximumLaserSetpoint(int maximumLaserSetpoint) {
        this.maximumLaserSetpoint = maximumLaserSetpoint;
    }

    public void setLaserPowerRegulation(boolean laserPowerRegulation) {
        this.laserPowerRegulation = laserPowerRegulation;
    }

    public int getLaserPowerInfo() {
        return 0;
    }

    public void setLaserPowerInfo(int power) {
        this.laserPower = power;
    }

    public boolean isLaserPowerRegulation() {
        return this.laserPowerRegulation;
    }

    public int getMinimumLaserPowerSetpoint() {
        return this.minimumLaserPowerSetpoint;
    }

    public void setMinimumLaserPowerSetpoint(int minimumLaserPowerSetpoint) {
        this.minimumLaserPowerSetpoint = minimumLaserPowerSetpoint;
    }

    public int getMaximumLaserPowerSetpoint() {
        return this.maximumLaserPowerSetpoint;
    }

    public void setMaximumLaserPowerSetpoint(int maximumLaserPowerSetpoint) {
        this.maximumLaserPowerSetpoint = maximumLaserPowerSetpoint;
    }

    public String[] getFeatureGUIClassnames() {
        Vector<String> features = new Vector<String>();
        features.add(this.panelPath + "." + this.featurePath);
        return features.toArray(new String[0]);
    }
}

