/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer;

public class MMSRamanCalibration {
    private int maskRatio;
    private int maskFlipped;
    private String maskOrientation;
    private boolean spectraFlipped;
    private int[] maskIndices;
    private int[] maskXAlignmentAdjustments;
    private int[] maskYAlignmentAdjustments;
    private int sourcePeaks;
    private int[] shifts;
    public int polynomialOrder;
    public float[] observedPixels;
    public float[] actualWavelengths;
    private int numberOfDeadPixelColumnsLeft;
    private int numberOfDeadPixelColumnsRight;
    private String name;
    private String mask;
    private String spectralSource;
    private String serialNumber;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanCalibration;)V\ngetMaskRatio,()I\nsetMaskRatio,(I)V\ngetMaskFlipped,()I\nsetMaskFlipped,(I)V\ngetMaskOrientation,()Ljava/lang/String;\nisSpectraFlipped,()Z\nsetSpectraFlipped,(Z)V\ngetMaskIndices,()[I\nsetMaskIndices,([I)V\ngetMaskXAlignmentAdjustments,(I)I\ngetMaskXAlignmentAdjustments,()[I\nsetMaskXAlignmentAdjustments,([I)V\ngetMaskYAlignmentAdjustments,()[I\nsetMaskYAlignmentAdjustments,([I)V\ngetSourcePeaks,()I\nsetSourcePeaks,(I)V\ngetShifts,(I)I\ngetShifts,()[I\nsetShifts,(II)V\nsetShifts,([I)V\ngetPolynomialOrder,()I\nsetPolynomialOrder,(I)V\ngetObservedPixels,()[F\nsetObservedPixels,([F)V\ngetActualWavelengths,()[F\nsetActualWavelengths,([F)V\ngetNumberOfDeadPixelColumnsLeft,()I\nsetNumberOfDeadPixelColumnsLeft,(I)V\ngetNumberOfDeadPixelColumnsRight,()I\nsetNumberOfDeadPixelColumnsRight,(I)V\ngetName,()Ljava/lang/String;\nsetName,(Ljava/lang/String;)V\ngetMask,()Ljava/lang/String;\nsetMask,(Ljava/lang/String;)V\ngetSpectralSource,()Ljava/lang/String;\nsetSpectralSource,(Ljava/lang/String;)V\ngetSerialNumber,()Ljava/lang/String;\nsetSerialNumber,(Ljava/lang/String;)V\ntoString,()Ljava/lang/String;\n";

    public MMSRamanCalibration() {
    }

    public MMSRamanCalibration(MMSRamanCalibration calibration) {
        this.setActualWavelengths(calibration.getActualWavelengths());
        this.setMaskFlipped(calibration.getMaskFlipped());
        this.setMaskIndices(calibration.getMaskIndices());
        this.setMaskXAlignmentAdjustments(calibration.getMaskXAlignmentAdjustments());
        this.setMaskYAlignmentAdjustments(calibration.getMaskYAlignmentAdjustments());
        this.setNumberOfDeadPixelColumnsLeft(calibration.getNumberOfDeadPixelColumnsLeft());
        this.setNumberOfDeadPixelColumnsRight(calibration.getNumberOfDeadPixelColumnsRight());
        this.setObservedPixels(calibration.getObservedPixels());
        this.setPolynomialOrder(calibration.getPolynomialOrder());
        this.setSourcePeaks(calibration.getSourcePeaks());
        this.setSpectraFlipped(calibration.isSpectraFlipped());
        this.setShifts(calibration.getShifts());
    }

    public int getMaskRatio() {
        return this.maskRatio;
    }

    public void setMaskRatio(int maskRatio) {
        this.maskRatio = maskRatio;
    }

    public int getMaskFlipped() {
        return this.maskFlipped;
    }

    public void setMaskFlipped(int maskFlipped) {
        this.maskFlipped = maskFlipped;
    }

    public String getMaskOrientation() {
        switch (this.maskFlipped) {
            case 0: {
                this.maskOrientation = "no mask flip";
                break;
            }
            case 1: {
                this.maskOrientation = "vertically flipped mask";
                break;
            }
            case 2: {
                this.maskOrientation = "horizontally flipped mask";
                break;
            }
            case 3: {
                this.maskOrientation = "horizontally and vertically flipped mask";
                break;
            }
            default: {
                this.maskOrientation = "no mask flip";
            }
        }
        return this.maskOrientation;
    }

    public boolean isSpectraFlipped() {
        return this.spectraFlipped;
    }

    public void setSpectraFlipped(boolean spectraFlipped) {
        this.spectraFlipped = spectraFlipped;
    }

    public int[] getMaskIndices() {
        return this.maskIndices;
    }

    public void setMaskIndices(int[] maskIndices) {
        this.maskIndices = maskIndices;
    }

    public int getMaskXAlignmentAdjustments(int index) {
        return this.maskXAlignmentAdjustments[index];
    }

    public int[] getMaskXAlignmentAdjustments() {
        return this.maskXAlignmentAdjustments;
    }

    public void setMaskXAlignmentAdjustments(int[] maskXAlignmentAdjustments) {
        this.maskXAlignmentAdjustments = maskXAlignmentAdjustments;
    }

    public int[] getMaskYAlignmentAdjustments() {
        return this.maskYAlignmentAdjustments;
    }

    public void setMaskYAlignmentAdjustments(int[] maskYAlignmentAdjustments) {
        this.maskYAlignmentAdjustments = maskYAlignmentAdjustments;
    }

    public int getSourcePeaks() {
        return this.sourcePeaks;
    }

    public void setSourcePeaks(int sourcePeaks) {
        this.sourcePeaks = sourcePeaks;
    }

    public int getShifts(int index) {
        return this.shifts[index];
    }

    public int[] getShifts() {
        return this.shifts;
    }

    public void setShifts(int index, int shifts) {
        this.shifts[index] = shifts;
    }

    public void setShifts(int[] shifts) {
        this.shifts = shifts;
    }

    public int getPolynomialOrder() {
        return this.polynomialOrder;
    }

    public void setPolynomialOrder(int polynomialOrder) {
        this.polynomialOrder = polynomialOrder;
    }

    public float[] getObservedPixels() {
        return this.observedPixels;
    }

    public void setObservedPixels(float[] observedPixels) {
        this.observedPixels = observedPixels;
    }

    public float[] getActualWavelengths() {
        return this.actualWavelengths;
    }

    public void setActualWavelengths(float[] actualWavelengths) {
        this.actualWavelengths = actualWavelengths;
    }

    public int getNumberOfDeadPixelColumnsLeft() {
        return this.numberOfDeadPixelColumnsLeft;
    }

    public void setNumberOfDeadPixelColumnsLeft(int numberOfDeadPixelColumnsLeft) {
        this.numberOfDeadPixelColumnsLeft = numberOfDeadPixelColumnsLeft;
    }

    public int getNumberOfDeadPixelColumnsRight() {
        return this.numberOfDeadPixelColumnsRight;
    }

    public void setNumberOfDeadPixelColumnsRight(int numberOfDeadPixelColumnsRight) {
        this.numberOfDeadPixelColumnsRight = numberOfDeadPixelColumnsRight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getSpectralSource() {
        return this.spectralSource;
    }

    public void setSpectralSource(String spectralSource) {
        this.spectralSource = spectralSource;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String toString() {
        int i;
        String s = "\nSpectrometer Calibration:";
        s = s + "\n\tRequired mask indices: ";
        int[] m = this.getMaskIndices();
        for (int i2 = 0; i2 < m.length; ++i2) {
            s = s + m[i2] + ", ";
        }
        s = s + "\n\tMask X alignment adjustments: ";
        int[] x = this.getMaskXAlignmentAdjustments();
        for (int i3 = 0; i3 < x.length; ++i3) {
            s = s + x[i3] + ", ";
        }
        s = s + "\n\tMask Y alignment adjustments: ";
        int[] y = this.getMaskYAlignmentAdjustments();
        for (int i4 = 0; i4 < y.length; ++i4) {
            s = s + y[i4] + ", ";
        }
        s = s + "\n\tNumber of source peaks: " + this.getSourcePeaks() + "\n\tShifts: ";
        int[] sh = this.getShifts();
        for (int i5 = 0; i5 < sh.length; ++i5) {
            s = s + sh[i5] + ", ";
        }
        s = s + "\n\tPolynomial order: " + this.getPolynomialOrder() + "\n\tPixels: ";
        float[] p = this.getObservedPixels();
        for (i = 0; i < p.length; ++i) {
            s = s + p[i] + ", ";
        }
        s = s + "\n\tWavelengths: ";
        p = this.getActualWavelengths();
        for (i = 0; i < p.length; ++i) {
            s = s + p[i] + ", ";
        }
        s = s + "\n\tDead pixels left: " + this.getNumberOfDeadPixelColumnsLeft() + "\n\tDead pixels right: " + this.getNumberOfDeadPixelColumnsRight() + "\n\tName: " + this.getName() + "\n\tMask: " + this.getMask() + "\n\tSpectral source: " + this.getSpectralSource() + "\n\tSerial number: " + this.getSerialNumber();
        return s;
    }
}

