/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.qe65000;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClock;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClockImpl;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersionImpl;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperature;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl_QE65000;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_FPGA;
import com.oceanoptics.omnidriver.features.exposureimage.ExposureImageGUIProvider;
import com.oceanoptics.omnidriver.features.exposureimage.ExposureImageImpl;
import com.oceanoptics.omnidriver.features.exposureimage.ExposureListener;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplFPGA;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImplFPGA;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImplFPGA;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisor;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisorImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplFPGA;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClock;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClockImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusGUIProvider;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImplFPGA;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectric;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricGUIProvider;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl_QE65000;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.ExposureImageable;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.IntegrationTimeChangeListener;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.SpectrometerExposure;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.qe65000.QE65000TriggerMode;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Vector;

public class QE65000
extends USBSpectrometer
implements PlugInProvider,
I2CBus,
SPIBus,
AdvancedVersion,
ContinuousStrobe,
AdvancedIntegrationClock,
HardwareTrigger,
ShutterClock,
SingleStrobe,
GPIO,
BoardTemperature,
ThermoElectric,
IrradianceCalibrationFactor,
MasterClockDivisor,
ExternalTriggerDelay,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
Version,
ExposureImageable,
USBEndpointDevice {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private PlugInProvider plugInProvider;
    private AdvancedVersion advancedVersion;
    private AdvancedIntegrationClock advancedIntegrationClock;
    private ShutterClock shutterClock;
    private MasterClockDivisor masterClockDivisor;
    private StrayLightCorrectionGUIProvider straylight;
    private I2CBusGUIProvider i2cBus;
    private SPIBusGUIProvider spiBus;
    private GPIOGUIProvider gpio;
    private SingleStrobeGUIProvider singleStrobe;
    private HardwareTriggerImpl hardwareTrigger;
    private ContinuousStrobeGUIProvider continuousStrobe;
    private BoardTemperatureGUIProvider boardTemperature;
    private IrradianceCalibrationFactorGUIProvider irradianceCalibrationFactor;
    private ExternalTriggerDelayGUIProvider triggerDelay;
    private ThermoElectricGUIProvider tec;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationGUIProvider wavelength;
    private VersionGUIProvider version;
    private transient ArrayList exposureListenerList;
    protected int ccdWidth = 1044;
    protected int ccdHeight = 64;
    protected int ccdBitsPerPixel = 16;
    SpectrometerExposure lastExposure;
    private ExposureImageGUIProvider exposureImage;
    private boolean stabilityScanInProgress;
    private boolean mode = false;
    private int scanNumber = 0;
    private int NUMBER_GPIO_PINS = 10;
    private boolean supportsQueryPixelInfoCommand = false;
    private boolean supportsPageMode = false;
    private int imageModeIntegrationTime = 750;
    private int linearModeIntegrationTime = 100;
    private Vector integrationTimeChangeListeners = new Vector();
    private static final short DATA_OUT = 1;
    private static final short HIGH_SPEED_DATA_IN_1 = 130;
    private static final short HIGH_SPEED_DATA_IN_2 = 134;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetSaturationIntensity,(ILjava/lang/String;)Z\ngetSaturationIntensity,()I\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nallowWriteToEEPROM,(II)Z\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\nsetStrobeDelay,(I)V\ngetActualIntegrationTime,()I\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\nisPlugInDetected,(I)Z\ninitializePlugIns,()[B\ndetectPlugIns,()V\nsetI2CBytes,(BB[B)I\ngetI2CBytes,(BB)[B\ngetSPIBytes,([BI)[B\ngetPSOCVersion,()Ljava/lang/String;\ngetFPGAFirmwareVersion,()Ljava/lang/String;\ncontinuousStrobeCountsToMicros,(I)D\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\nsetAdvancedIntegrationTime,(J)V\ngetIntegrationTimeBaseClock,()I\ngetIntegrationClockTimer,()I\ngetAdvancedIntegrationTimeMinimum,()J\ngetAdvancedIntegrationTimeMaximum,()J\ngetAdvancedIntegrationTimeIncrement,()J\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nsetShutterClock,(I)V\ngetShutterClock,()I\nsetSingleStrobeLow,(I)V\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeLow,()I\ngetSingleStrobeHigh,()I\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeIncrement,()I\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetMuxBitmask,(S)V\nsetValueBitmask,(S)V\nsetDirectionBit,(IZ)V\nsetMuxBit,(IZ)V\nsetValueBit,(IZ)V\ngetTotalGPIOBits,()I\ngetDirectionBits,()Ljava/util/BitSet;\ngetMuxBits,()Ljava/util/BitSet;\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\ngetNumberOfPins,()I\ngetBoardTemperatureCelsius,()D\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\nsetMasterClockDivisor,(I)V\ngetMasterClockDivisor,()I\nsetExternalTriggerDelay,(I)V\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\ngetTECEnable,()Ljava/lang/Boolean;\nsetTECEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\nsetFanEnable,(Z)V\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\nsetDetectorSetPointCelsius,(D)V\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\ngetSpectrometer,()Lcom/oceanoptics/omnidriver/spectrometer/qe65000/QE65000;\naddExposureListener,(Lcom/oceanoptics/omnidriver/features/exposureimage/ExposureListener;)V\ngetCcdWidth,()I\ngetCcdHeight,()I\ngetLastExposure,()Lcom/oceanoptics/omnidriver/spectra/SpectrometerExposure;\nremoveExposureListener,(Lcom/oceanoptics/omnidriver/features/exposureimage/ExposureListener;)V\ngetQE65000Exposure,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/SpectrometerExposure;\nset2DMode,(I)V\nset1DMode,(I)V\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nhas1DMode,()Z\nis1DMode,()Z\nis2DMode,()Z\nget2DintegrationTime,()I\naddIntegrationTimeChangeListener,(Lcom/oceanoptics/omnidriver/interfaces/IntegrationTimeChangeListener;)V\nremoveIntegrationTimeChangeListener,(Lcom/oceanoptics/omnidriver/interfaces/IntegrationTimeChangeListener;)V\n";

    public QE65000() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public QE65000(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    public boolean setSaturationIntensity(int saturationIntensity, String key) {
        return false;
    }

    public int getSaturationIntensity() {
        return -1;
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 512, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 134, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public boolean allowWriteToEEPROM(int privilegeLevel, int slot) {
        if (slot < 0) {
            return false;
        }
        if (privilegeLevel == 0) {
            return true;
        }
        if (privilegeLevel == 1) {
            if (slot == 0) {
                return false;
            }
            if (slot == 19) {
                return true;
            }
            return slot <= 14;
        }
        return false;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 8000;
        this.integrationTimeMaximum = 1600000000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 1044;
        this.numberOfDarkCCDPixels = 3;
        this.maxIntensity = 65535;
        this.pipeSize = 2561;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 4120;
        this.mode = false;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine("QE65000 has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new Configuration(this);
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.plugInProvider = new PlugInProviderImplFPGA(usb, this);
        this.advancedVersion = new AdvancedVersionImpl(usb);
        this.advancedIntegrationClock = new AdvancedIntegrationClockImpl(usb);
        this.shutterClock = new ShutterClockImpl(usb);
        this.masterClockDivisor = new MasterClockDivisorImpl(usb);
        this.i2cBus = new I2CBusImplFPGA(usb);
        this.spiBus = new SPIBusImplFPGA(usb);
        this.gpio = new GPIOImpl(usb, this.NUMBER_GPIO_PINS);
        this.singleStrobe = new SingleStrobeImpl(usb);
        this.hardwareTrigger = this.hasNewFPGAFirmwareVersion() ? new HardwareTriggerImplFPGA(usb, new QE65000TriggerMode[]{new QE65000TriggerMode(0), new QE65000TriggerMode(1), new QE65000TriggerMode(2), new QE65000TriggerMode(3)}) : new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(3), new ExternalTriggerMode(4)});
        this.continuousStrobe = new ContinuousStrobeImpl_FPGA(usb);
        this.boardTemperature = new BoardTemperatureImpl_QE65000(usb);
        this.irradianceCalibrationFactor = new IrradianceCalibrationFactorImplFPGA(usb, this.numberOfCCDPixels);
        this.triggerDelay = new ExternalTriggerDelayImpl(usb);
        this.tec = new ThermoElectricImpl_QE65000(usb);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        String FPGAFirmwareVersion = this.getFPGAFirmwareVersion();
        double FX2 = 0.0;
        double FPGA2 = 0.0;
        try {
            int index1 = this.firmwareVersion.indexOf(32);
            int index2 = this.firmwareVersion.lastIndexOf(46);
            FX2 = Double.parseDouble(this.firmwareVersion.substring(index1 + 1, index2));
            int index3 = FPGAFirmwareVersion.lastIndexOf(46);
            FPGA2 = Double.parseDouble(FPGAFirmwareVersion.substring(0, index3));
            if (FX2 >= 3.0) {
                this.supportsQueryPixelInfoCommand = true;
            }
            if (FX2 >= 3.0 && FPGA2 >= 3.0) {
                this.findCCDSize();
            }
            if (FX2 >= 2.5 && FPGA2 >= 2.0) {
                this.supportsPageMode = true;
                this.exposureImage = new ExposureImageImpl(this);
            }
        }
        catch (Exception e) {
            this.supportsQueryPixelInfoCommand = false;
            this.supportsPageMode = false;
        }
        this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        this.featureMap.put(AdvancedVersionImpl.class, (AdvancedVersionImpl)this.advancedVersion);
        this.featureMap.put(AdvancedIntegrationClockImpl.class, (AdvancedIntegrationClockImpl)this.advancedIntegrationClock);
        this.featureMap.put(ShutterClockImpl.class, (ShutterClockImpl)this.shutterClock);
        this.featureMap.put(MasterClockDivisorImpl.class, (MasterClockDivisorImpl)this.masterClockDivisor);
        this.featureMap.put(I2CBusImpl.class, (I2CBusImpl)this.i2cBus);
        this.featureMap.put(SPIBusImpl.class, (SPIBusImpl)this.spiBus);
        this.featureMap.put(GPIOImpl.class, (GPIOImpl)this.gpio);
        this.featureMap.put(SingleStrobeImpl.class, (SingleStrobeImpl)this.singleStrobe);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(ContinuousStrobeImpl.class, (ContinuousStrobeImpl)this.continuousStrobe);
        this.featureMap.put(BoardTemperatureImpl.class, (BoardTemperatureImpl)this.boardTemperature);
        this.featureMap.put(IrradianceCalibrationFactorImpl.class, (IrradianceCalibrationFactorImpl)this.irradianceCalibrationFactor);
        this.featureMap.put(ExternalTriggerDelayImpl.class, (ExternalTriggerDelayImpl)this.triggerDelay);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
        this.featureMap.put(ThermoElectricImpl.class, (ThermoElectricImpl)this.tec);
        if (this.supportsPageMode) {
            this.featureMap.put(ExposureImageImpl.class, (ExposureImageImpl)this.exposureImage);
        }
    }

    public GUIProvider[] getGUIFeatures() {
        if (this.supportsPageMode) {
            return new GUIProvider[]{this.exposureImage, this.wavelength, this.straylight, this.nonlinearity, this.singleStrobe, this.continuousStrobe, this.triggerDelay, this.i2cBus, this.spiBus, this.gpio, this.boardTemperature, this.tec, this.irradianceCalibrationFactor, this.version};
        }
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.singleStrobe, this.continuousStrobe, this.triggerDelay, this.i2cBus, this.spiBus, this.gpio, this.boardTemperature, this.tec, this.irradianceCalibrationFactor, this.version};
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        int pixel;
        byte LSB;
        byte MSB;
        int i;
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        doubleSpectrum.setSaturated(false);
        if (data[this.pipeSize - 1] != 105) {
            this.logger.severe("Lost synchroniztion");
            throw new IOException("Lost synchronization");
        }
        for (i = 0; i < 1024; ++i) {
            MSB = data[i * 2 + 21];
            LSB = data[i * 2 + 20];
            pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x8000;
            if (pixel >= this.maxIntensity) {
                doubleSpectrum.setSaturated(true);
            }
            spectrum[i] = pixel;
        }
        for (i = 0; i < 10; ++i) {
            MSB = data[i * 2 + 1];
            LSB = data[i * 2];
            pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x8000;
            if (pixel >= this.maxIntensity) {
                doubleSpectrum.setSaturated(true);
            }
            spectrum[i + 1024] = pixel;
        }
        for (i = 0; i < 10; ++i) {
            MSB = data[i * 2 + 2069];
            LSB = data[i * 2 + 2068];
            pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x8000;
            if (pixel >= this.maxIntensity) {
                doubleSpectrum.setSaturated(true);
            }
            spectrum[i + 1034] = pixel;
        }
        return doubleSpectrum;
    }

    private Spectrum derive1DSpectrumFrom2DData(int[][] imageData, Spectrum doubleSpectrum) throws IOException {
        double[] spectrum = new double[1024];
        int spectrumIndex = 0;
        for (int i = 10; i < this.getCcdWidth() - 10; ++i) {
            double pixelValue = 0.0;
            for (int j = 0; j < this.getCcdHeight(); ++j) {
                pixelValue += (double)imageData[j][i];
                if (imageData[j][i] < this.maxIntensity) continue;
                doubleSpectrum.setSaturated(true);
            }
            spectrum[spectrumIndex] = pixelValue / (double)this.getCcdHeight();
            ++spectrumIndex;
        }
        doubleSpectrum.setSpectrum(spectrum);
        return doubleSpectrum;
    }

    private void findCCDSize() throws IOException {
        short filler = 0;
        this.out[0] = 107;
        this.out[1] = 120;
        this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
        this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 3);
        this.ccdHeight = ByteRoutines.makeDWord((short)filler, (short)ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[1]));
        this.out[0] = 107;
        this.out[1] = 124;
        this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
        this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 3);
        this.ccdWidth = ByteRoutines.makeDWord((short)filler, (short)ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[1]));
    }

    private boolean hasNewFPGAFirmwareVersion() {
        double FX2 = 0.0;
        double FPGA2 = 0.0;
        int patchlevel = 0;
        try {
            String fpgaVersion = this.getFPGAFirmwareVersion();
            int index1 = this.firmwareVersion.indexOf(32);
            int index2 = this.firmwareVersion.lastIndexOf(46);
            FX2 = Double.parseDouble(this.firmwareVersion.substring(index1 + 1, index2));
            int index3 = fpgaVersion.lastIndexOf(46);
            FPGA2 = Double.parseDouble(fpgaVersion.substring(0, index3));
            patchlevel = Integer.parseInt(fpgaVersion.substring(index3 + 1, fpgaVersion.length()));
            return (FPGA2 += (double)((float)patchlevel / 1000.0f)) >= 3.237;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setStrobeDelay(int delay) throws IOException {
        this.setContinuousStrobeDelay(delay);
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime();
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        return this.plugInProvider.getPlugIns();
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        return this.i2cBus.setI2CBytes(address, numBytes, i2C);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        return this.i2cBus.getI2CBytes(address, numBytes);
    }

    public byte[] getSPIBytes(byte[] message, int length) throws IOException {
        return this.spiBus.getSPIBytes(message, length);
    }

    public String getPSOCVersion() throws IOException {
        return this.advancedVersion.getPSOCVersion();
    }

    public String getFPGAFirmwareVersion() throws IOException {
        return this.advancedVersion.getFPGAFirmwareVersion();
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(delayMicros);
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public void setAdvancedIntegrationTime(long delayMicros) throws IOException {
        this.advancedIntegrationClock.setAdvancedIntegrationTime(delayMicros);
    }

    public int getIntegrationTimeBaseClock() throws IOException {
        return this.advancedIntegrationClock.getIntegrationTimeBaseClock();
    }

    public int getIntegrationClockTimer() throws IOException {
        return this.advancedIntegrationClock.getIntegrationClockTimer();
    }

    public long getAdvancedIntegrationTimeMinimum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMinimum();
    }

    public long getAdvancedIntegrationTimeMaximum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMaximum();
    }

    public long getAdvancedIntegrationTimeIncrement() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeIncrement();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public void setShutterClock(int value) throws IOException {
        this.shutterClock.setShutterClock(value);
    }

    public int getShutterClock() throws IOException {
        return this.shutterClock.getShutterClock();
    }

    public void setSingleStrobeLow(int value) throws IOException {
        this.singleStrobe.setSingleStrobeLow(value);
    }

    public void setSingleStrobeHigh(int value) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(value);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public double getBoardTemperatureCelsius() throws IOException {
        return this.boardTemperature.getBoardTemperatureCelsius();
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        return this.irradianceCalibrationFactor.getIrradianceCalibrationFactors();
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        this.irradianceCalibrationFactor.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradianceCalibrationFactor.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradianceCalibrationFactor.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradianceCalibrationFactor.setCollectionArea(area);
    }

    public void setMasterClockDivisor(int value) throws IOException {
        this.masterClockDivisor.setMasterClockDivisor(value);
    }

    public int getMasterClockDivisor() throws IOException {
        return this.masterClockDivisor.getMasterClockDivisor();
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public Boolean getTECEnable() {
        return this.tec.getTECEnable();
    }

    public void setTECEnable(boolean enable) throws IOException {
        this.tec.setTECEnable(enable);
    }

    public Boolean getFanEnable() {
        return this.tec.getFanEnable();
    }

    public void setFanEnable(boolean enable) throws IOException {
        this.tec.setFanEnable(enable);
    }

    public double getDetectorTemperatureCelsius() throws IOException {
        return this.tec.getDetectorTemperatureCelsius();
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        return this.tec.getDetectorTemperatureSetPointCelsius();
    }

    public Double getDetectorSetPointCelsius() {
        return this.tec.getDetectorSetPointCelsius();
    }

    public void setDetectorSetPointCelsius(double point) throws IOException {
        this.tec.setDetectorSetPointCelsius(point);
    }

    public double getSetPointMinimumCelsius() {
        return this.tec.getSetPointMinimumCelsius();
    }

    public double getSetPointMaximumCelsius() {
        return this.tec.getSetPointMaximumCelsius();
    }

    public double getSetPointIncrementCelsius() {
        return this.tec.getSetPointIncrementCelsius();
    }

    public boolean isSaveTECStateEnabled() {
        return this.tec.isSaveTECStateEnabled();
    }

    public void saveTECState() throws IOException {
        this.tec.saveTECState();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doStabilityScan(int numScans) throws IOException {
        QE65000 ht;
        Integer htmode;
        if (this instanceof HardwareTrigger && (htmode = (ht = this).getExternalTriggerMode()) != null && htmode == 4) {
            System.err.println("Not doing stability scan!");
            return;
        }
        this.stabilityScanInProgress = true;
        if (this.is2DMode()) {
            Spectrum spectrum = new Spectrum(this.getCcdWidth() * this.getCcdHeight(), this.getNumberOfDarkPixels());
            for (int i = 0; i < numScans; ++i) {
                this.getQE65000Exposure(spectrum);
            }
        } else if (this.is1DMode()) {
            byte[] byArray = this.in;
            // MONITORENTER : this.in
            byte[] byArray2 = this.out;
            // MONITORENTER : this.out
            for (int i = 0; i < numScans; ++i) {
                this.requestSpectrum();
                this.readSpectrum();
            }
            // MONITOREXIT : byArray2
            // MONITOREXIT : byArray
        }
        this.stabilityScanInProgress = false;
    }

    public QE65000 getSpectrometer() {
        return this;
    }

    public synchronized void addExposureListener(ExposureListener listener) {
        if (this.exposureListenerList == null) {
            this.exposureListenerList = new ArrayList();
        }
        this.exposureListenerList.add(listener);
    }

    public int getCcdWidth() {
        return this.ccdWidth;
    }

    public int getCcdHeight() {
        return this.ccdHeight;
    }

    public SpectrometerExposure getLastExposure() {
        return this.lastExposure;
    }

    public synchronized void removeExposureListener(ExposureListener listener) {
        if (this.exposureListenerList != null) {
            this.exposureListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireExposureListenerNewQE65000Exposure(SpectrometerExposure event) {
        ArrayList list;
        QE65000 qE65000 = this;
        synchronized (qE65000) {
            if (this.exposureListenerList == null) {
                return;
            }
            list = (ArrayList)this.exposureListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ExposureListener)list.get(i)).newSpectrometerExposure(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectrometerExposure getQE65000Exposure(Spectrum spectrum) throws IOException {
        if (this.lastExposure == null) {
            this.lastExposure = new SpectrometerExposure(this);
        }
        int packetSize = 512;
        int numberOfPackets = this.ccdWidth * this.ccdHeight * 2 / 512;
        int imageSize = this.ccdWidth * this.ccdHeight * 2;
        byte[] exposureIn = new byte[imageSize];
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 117;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                int position = 0;
                int bytesToGo = imageSize;
                if (this.supportsQueryPixelInfoCommand) {
                    this.out[0] = -3;
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 16);
                    numberOfPackets = ByteRoutines.makeWord((byte)this.in[7], (byte)this.in[6]);
                    bytesToGo = numberOfPackets * 512;
                }
                int bytesRead = 0;
                int packetNumber = 1;
                long first = System.currentTimeMillis();
                while (bytesToGo > 0) {
                    long startTime = System.currentTimeMillis();
                    int bytesToRead = Math.min(packetSize, bytesToGo);
                    this.usb.bulkIn(this.highSpeedInEndPoint1, this.in, bytesToRead);
                    bytesRead += bytesToRead;
                    System.arraycopy(this.in, 0, exposureIn, position, bytesToRead);
                    bytesToGo -= bytesToRead;
                    position += bytesToRead;
                    ++packetNumber;
                    long endTime = System.currentTimeMillis();
                }
                int[][] imageData = new int[this.ccdHeight][this.ccdWidth];
                position = 0;
                for (int i = 0; i < this.ccdHeight; ++i) {
                    for (int j = 0; j < this.ccdWidth; ++j) {
                        byte lowByte = exposureIn[position++];
                        byte highByte = exposureIn[position++];
                        short word = ByteRoutines.makeWord((byte)highByte, (byte)lowByte);
                        word = (short)(word ^ 0x8000);
                        imageData[i][j] = word & 0xFFFF;
                    }
                }
                this.derive1DSpectrumFrom2DData(imageData, spectrum);
                this.lastExposure.setImageData(imageData);
                this.lastExposure.setBitsPerPixel(this.ccdBitsPerPixel);
                if (!this.stabilityScanInProgress) {
                    this.fireExposureListenerNewQE65000Exposure(this.lastExposure);
                }
                // ** MonitorExit[var14_7] (shouldn't be in output)
            }
            return this.lastExposure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set2DMode(int channelIndex) throws IOException {
        this.linearModeIntegrationTime = this.integrationTime / this.integrationTimeBase;
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 116;
            this.out[1] = 1;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
            this.mode = true;
            this.scanNumber = 0;
            this.out[0] = 2;
            if (this.getCcdHeight() >= 128) {
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)1250));
                this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)1250));
                this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)1250));
                this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)1250));
                this.imageModeIntegrationTime = 1250;
            } else {
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)750));
                this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)750));
                this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)750));
                this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)750));
                this.imageModeIntegrationTime = 750;
            }
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 5);
            this.fireIntegrationTimeChanged(this.imageModeIntegrationTime * 1000);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1DMode(int channelIndex) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 116;
            this.out[1] = 0;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
            this.mode = false;
            this.out[0] = 2;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)this.linearModeIntegrationTime));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)this.linearModeIntegrationTime));
            this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)this.linearModeIntegrationTime));
            this.out[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)this.linearModeIntegrationTime));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 5);
            this.fireIntegrationTimeChanged(this.linearModeIntegrationTime * 1000);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        this.timeoutOccurredFlag = false;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                block10: {
                    try {
                        if (this.is2DMode()) {
                            this.getQE65000Exposure(spectrum);
                            break block10;
                        }
                        if (this.is1DMode()) {
                            this.requestSpectrum();
                            this.readSpectrum();
                            spectrum.setSaturated(false);
                            this.formatData(this.rawData, spectrum);
                            break block10;
                        }
                        throw new IllegalStateException("Not in either 1D or 2D mode.");
                    }
                    catch (IOException exception) {
                        this.timeoutOccurredFlag = this.determineWhetherTimeoutOccurred(exception);
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return spectrum;
        }
    }

    public boolean has1DMode() {
        return true;
    }

    public boolean is1DMode() {
        return !this.mode;
    }

    public boolean is2DMode() {
        return this.mode;
    }

    public int get2DintegrationTime() {
        return this.imageModeIntegrationTime;
    }

    public void addIntegrationTimeChangeListener(IntegrationTimeChangeListener listener) {
        this.integrationTimeChangeListeners.add(listener);
    }

    public void removeIntegrationTimeChangeListener(IntegrationTimeChangeListener listener) {
        this.integrationTimeChangeListeners.remove(listener);
    }

    private void fireIntegrationTimeChanged(int time) {
        IntegrationTimeChangeListener[] l = this.integrationTimeChangeListeners.toArray(new IntegrationTimeChangeListener[this.integrationTimeChangeListeners.size()]);
        for (int i = 0; i < l.length; ++i) {
            l[i].integrationTimeChanged(time);
        }
    }
}

