/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.simulation;

import com.oceanoptics.omnidriver.features.simulation.SimulationGUIProvider;
import com.oceanoptics.omnidriver.features.simulation.SimulationImpl;
import com.oceanoptics.omnidriver.features.simulation.SimulationProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.simulation.SimulationChannel;
import com.oceanoptics.spam.coreprocessing.CoreBlackbodySpectrum;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class Simulation
extends USBSpectrometer
implements SimulationProvider,
WavelengthCalibrationProvider {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private SimulationGUIProvider simulation;
    private WavelengthCalibrationGUIProvider wavelength;
    private Random generator = new Random();
    private static final int BLACKBODY_SPECTRUM = 0;
    private static final int FILTERED_BLACKBODY = 1;
    private static final int INCREASING_SPECTRUM = 2;
    private static final int RANDOM_SPECTRUM = 3;
    private static final double SATURATION_INT_TIME_USEC = 150000.0;
    private double colorTemperature = 5000.0;
    private int spectrumType = 0;
    private SimulationChannel channel;
    private static String __extern__ = "__extern__\n<init>,(I)V\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nsetNumberOfPixels,(II)V\nsetSpectrumType,(I)V\ngetTest,(Ljava/lang/String;)Ljava/lang/String;\ngetSerialNumber,()Ljava/lang/String;\ngetFirmwareVersion,()Ljava/lang/String;\nsetStrobeEnable,(Z)V\nsetIntegrationTime,(I)V\ncloseSpectrometer,()V\ngetInfo,(I)Ljava/lang/String;\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\n";

    public Simulation(int i) throws IOException {
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 4095;
        this.channels = new SimulationChannel[1];
        this.channels[this.channelIndex] = new SimulationChannel(this, new Coefficients(), this.channelIndex);
        this.channel = (SimulationChannel)this.channels[0];
        this.logger.info("Simulation has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.simulation = new SimulationImpl(this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.featureMap.put(SimulationImpl.class, (SimulationImpl)this.simulation);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
    }

    protected void finishConstruction() throws IOException {
        this.numberOfPixels = this.numberOfCCDPixels;
        this.numberOfDarkPixels = this.numberOfDarkCCDPixels;
        this.channel.getCoefficientsFromSpectrometer();
        this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), null, this.numChannels, this.getNumberOfCCDPixels(), this.getNumberOfDarkCCDPixels(), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        this.channel.generateMetadata(this.spectrumBase, 0);
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.simulation);
        features.add(this.wavelength);
        return features.toArray(new GUIProvider[0]);
    }

    protected Spectrum formatData(byte[] data, Spectrum spectrum) throws IOException {
        return spectrum;
    }

    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.logger.finest("Getting spectrum...");
        this.timeoutOccurredFlag = false;
        try {
            Thread.sleep(this.integrationTime / this.integrationTimeBase);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        spectrum.setSpectrum(this.getPixelValues());
        for (int i = 0; i < spectrum.getSpectrum().length; ++i) {
            if (spectrum.getSpectrum()[i] != (double)this.maxIntensity) continue;
            spectrum.setSaturated(true);
            break;
        }
        return spectrum;
    }

    private double[] getPixelValues() {
        double[] temp = new double[this.numberOfPixels];
        switch (this.spectrumType) {
            case 0: 
            case 1: {
                int i;
                double scale = (double)(this.maxIntensity * this.integrationTime) / 150000.0;
                if (this.strobeOn.booleanValue()) {
                    temp = CoreBlackbodySpectrum.calcBlackbodySpectrumNormalizedOneAtPeak((double[])this.channel.getAllWavelengths(), (double)this.colorTemperature);
                    for (i = this.channel.getNumberOfDarkPixels(); i < temp.length; ++i) {
                        if (1 == this.spectrumType) {
                            double filter = Math.sin(Math.PI * 5 * ((double)i / (double)this.channel.getNumberOfPixels())) / 2.0 + 0.5;
                            filter *= Math.cos(Math.PI * 3 * ((double)i / (double)this.channel.getNumberOfPixels())) / 2.0 + 0.5;
                            filter *= 0.8;
                            int n = i;
                            temp[n] = temp[n] * (filter += 0.2);
                        }
                        int n = i;
                        temp[n] = temp[n] * scale;
                        int n2 = i;
                        temp[n2] = temp[n2] + (120.0 + 5.0 * this.generator.nextGaussian());
                        temp[i] = Math.min(temp[i], (double)this.maxIntensity);
                    }
                } else {
                    for (i = 0; i < this.channel.getNumberOfPixels(); ++i) {
                        temp[i] = 120.0 + 5.0 * this.generator.nextGaussian();
                    }
                }
                temp[0] = 0.0;
                for (i = 1; i < this.channel.getNumberOfDarkPixels(); ++i) {
                    temp[i] = 120.0 + this.generator.nextGaussian() * 5.0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.numberOfPixels; ++i) {
                    temp[i] = i;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.numberOfPixels; ++i) {
                    temp[i] = this.generator.nextGaussian() * (double)(this.maxIntensity / 4);
                }
                break;
            }
        }
        return temp;
    }

    public void setNumberOfPixels(int pixels, int dark) throws IOException {
        this.numberOfCCDPixels = pixels;
        this.numberOfDarkCCDPixels = dark;
        this.numberOfPixels = pixels;
        this.numberOfDarkPixels = dark;
        this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), null, this.numChannels, this.getNumberOfCCDPixels(), this.getNumberOfDarkCCDPixels(), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        this.channel.generateMetadata(this.spectrumBase, 0);
        this.channel.fixNumberOfPixels();
    }

    public void setSpectrumType(int type) {
        this.spectrumType = type < 0 || type > 3 ? 0 : type;
    }

    public String getTest(String test) {
        return "This is a test of the simulation: " + test;
    }

    public String getSerialNumber() throws IOException {
        return "0000";
    }

    public String getFirmwareVersion() throws IOException {
        this.firmwareVersion = "0000";
        return this.firmwareVersion;
    }

    public void setStrobeEnable(boolean strobe) throws IOException {
        if (this.strobeOn == null) {
            this.strobeOn = new Boolean(strobe);
        } else if (this.strobeOn == strobe) {
            this.logger.fine("Desired strobe enable state already set, not pushing to spectrometer");
            return;
        }
        this.strobeOn = strobe ? Boolean.TRUE : Boolean.FALSE;
        this.logger.fine("Strobe enabled: " + strobe);
    }

    public void setIntegrationTime(int intTime) throws IOException {
        int maxTime = this.getIntegrationTimeMaximum();
        int minTime = this.getIntegrationTimeMinimum();
        if (intTime < minTime) {
            intTime = minTime;
        } else if (intTime > maxTime) {
            intTime = maxTime;
        }
        this.integrationTime = intTime;
        this.logger.fine("Integration time set to: " + (intTime /= this.getIntegrationTimeBase()));
    }

    protected void doStabilityScan(int numScans) throws IOException {
    }

    public void closeSpectrometer() throws IOException {
    }

    protected void finalize() {
    }

    public String getInfo(int slot) throws IOException {
        return "X";
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }
}

