/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.usb2000;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.constants.USBProductInfo;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.flgated.FlGated;
import com.oceanoptics.omnidriver.features.flgated.FlGatedGUIProvider;
import com.oceanoptics.omnidriver.features.flgated.FlGatedImpl;
import com.oceanoptics.omnidriver.features.flgated.GateDelayListener;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplNonFPGA;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImplNonFPGA;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImplNonFPGA;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsImpl;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsImpl_2000;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRate;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl_2000;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplNonFPGA;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusGUIProvider;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImplNonFPGA;
import com.oceanoptics.omnidriver.features.statusprovider.StatusProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class USB2000
extends USBSpectrometer
implements HardwareTrigger,
StatusProvider,
PlugInProvider,
MasterClockRate,
IrradianceCalibrationFactor,
SPIBus,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
I2CBus,
Version,
FlGated,
USBEndpointDevice {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private PlugInProvider plugInProvider;
    private MasterClockRate masterClockRate;
    private StrayLightCorrectionGUIProvider straylight;
    private IrradianceCalibrationFactorGUIProvider irradianceCalibrationFactor;
    private HardwareTriggerImpl hardwareTrigger;
    private SPIBusGUIProvider spiBus;
    private LS450_FunctionsImpl_2000 ls450Feature;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationGUIProvider wavelength;
    private I2CBusGUIProvider i2cBus;
    private VersionGUIProvider version;
    private FlGatedGUIProvider flGated;
    private boolean flGatedFW = false;
    private boolean curie = false;
    private int strobeDelay = 100;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nopenSpectrometer,(I)V\ngetUniUsb,()Lcom/oceanoptics/omnidriver/interfaces/USBInterface;\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\nisFlGated,()Z\nisCurie,()Z\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\nsetMasterClock,(I)V\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\ngetActualIntegrationTime,()I\nsetStrobeDelay,(I)V\ngetStrobeDelay,()I\ngetName,()Ljava/lang/String;\ngetSPIBytes,([BI)[B\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nisPlugInDetected,(I)Z\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\ninitializePlugIns,()[B\ndetectPlugIns,()V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nsetI2CBytes,(BB[B)I\ngetI2CBytes,(BB)[B\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\ngetGateIncrement,()I\ngetGateMaximum,()I\ngetGateMinimum,()I\nsetGateFrequency,(I)V\ngetGateFrequency,()I\naddGateDelayListener,(Lcom/oceanoptics/omnidriver/features/flgated/GateDelayListener;)V\nremoveGateDelayListener,(Lcom/oceanoptics/omnidriver/features/flgated/GateDelayListener;)V\ntoString,()Ljava/lang/String;\n";

    public USB2000() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public USB2000(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 4095;
        this.pipeSize = this.numberOfCCDPixels * 2 + 1;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 4098;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.configuration = new Configuration(this);
        this.flGatedFW = this.isFlGated();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine(this.getName() + " has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
    }

    public USBInterface getUniUsb() {
        return this.usb;
    }

    private void initFeatures(USBInterface usb) throws IOException {
        if (this.firmwareVersionNumber > 1003000) {
            this.plugInProvider = new PlugInProviderImplNonFPGA(usb, this);
            this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        }
        if (2050000 <= this.firmwareVersionNumber) {
            this.masterClockRate = new MasterClockRateImpl_2000(usb);
            this.featureMap.put(MasterClockRateImpl.class, (MasterClockRateImpl)this.masterClockRate);
        }
        this.irradianceCalibrationFactor = new IrradianceCalibrationFactorImplNonFPGA(usb, this.numberOfCCDPixels);
        this.featureMap.put(IrradianceCalibrationFactorImpl.class, (IrradianceCalibrationFactorImpl)this.irradianceCalibrationFactor);
        this.hardwareTrigger = new HardwareTriggerImplNonFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(3)});
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.ls450Feature = new LS450_FunctionsImpl_2000(usb, null);
        this.featureMap.put(LS450_FunctionsImpl.class, this.ls450Feature);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        if (1000000 <= this.firmwareVersionNumber) {
            this.spiBus = new SPIBusImplNonFPGA(usb);
            this.featureMap.put(SPIBusImpl.class, (SPIBusImpl)this.spiBus);
        }
        if (2050000 <= this.firmwareVersionNumber) {
            this.i2cBus = new I2CBusImplNonFPGA(usb);
            this.featureMap.put(I2CBusImpl.class, (I2CBusImpl)this.i2cBus);
        }
        if (this.flGatedFW) {
            this.flGated = new FlGatedImpl(usb, this);
            this.featureMap.put(FlGatedImpl.class, (FlGatedImpl)this.flGated);
        }
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.wavelength);
        features.add(this.straylight);
        features.add(this.nonlinearity);
        if (1000000 <= this.firmwareVersionNumber) {
            features.add(this.spiBus);
        }
        if (2050000 <= this.firmwareVersionNumber) {
            features.add(this.i2cBus);
        }
        features.add(this.version);
        return features.toArray(new GUIProvider[0]);
    }

    protected Spectrum formatData(byte[] data, Spectrum spectrum) throws IOException {
        this.logger.finest("Formatting spectrum...");
        spectrum.setSaturated(false);
        double[] spectrumArray = spectrum.getSpectrum();
        byte zero = 0;
        if (data[this.numberOfCCDPixels * 2] != 105) {
            this.logger.severe("Lost synchronization");
            throw new IOException("Lost synchronization");
        }
        for (int i = spectrumArray.length - 1; i >= 0; --i) {
            int LSBPacket = i >> 6;
            int MSBPacket = LSBPacket + 1;
            byte MSB = data[(MSBPacket << 6) + i];
            byte LSB = data[(LSBPacket << 6) + i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) & 0xFFF;
            if (pixel >= this.maxIntensity) {
                spectrum.setSaturated(true);
            }
            spectrumArray[i] = pixel;
        }
        return spectrum;
    }

    public boolean isFlGated() throws IOException {
        if (this.firmwareVersion == null) {
            this.getFirmwareVersion();
        }
        if (this.configuration == null) {
            this.configuration = this.getConfiguration();
        }
        String s = this.firmwareVersion.substring(0, 10);
        String t = this.firmwareVersion.substring(0, 11);
        if (s.equalsIgnoreCase("USB2000FLG") || t.equalsIgnoreCase("USB2000-FLG") || t.equalsIgnoreCase("USB2000 FLG")) {
            this.flGatedFW = true;
            this.strobeDelayEnabled = true;
            this.curie = this.isCurie();
        } else if (null != this.configuration.getCpldVersion() && this.configuration.getCpldVersion().equalsIgnoreCase("FLG")) {
            this.flGatedFW = true;
            this.strobeDelayEnabled = true;
            this.curie = this.isCurie();
        } else {
            this.flGatedFW = false;
        }
        return this.flGatedFW;
    }

    public boolean isCurie() throws IOException {
        return this.flGatedFW && this.getSerialNumber().substring(0, 3).equalsIgnoreCase("CUR");
    }

    public SpectrometerStatus getStatus() throws IOException {
        byte[] sb;
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 41, 0)) {
            this.logger.severe("Firmware must be greater than 2.41.00");
            sb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        } else {
            sb = this.getStatusArray();
        }
        SpectrometerStatus stat = new SpectrometerStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[0], (byte)sb[1]);
        stat.integrationTime = ByteRoutines.makeWord((byte)sb[2], (byte)sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7] == 0 ? 16 : 8;
        stat.dataReady = sb[8] != 0;
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        SpectrometerStatus stat = this.getStatus();
        return stat.integrationTime;
    }

    public void setMasterClock(int freq) throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 50, 0)) {
            this.logger.severe("Firmware must be greater than 2.50.00");
            throw new UnsupportedOperationException("Firmware must be greater than 2.50.00");
        }
        this.masterClockRate.setMasterClock(freq);
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 50, 0)) {
            this.logger.severe("Firmware must be greater than 2.50.00");
            throw new UnsupportedOperationException("Firmware must be greater than 2.50.00");
        }
        double[] ir = this.irradianceCalibrationFactor.getIrradianceCalibrationFactors();
        return ir;
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 50, 0)) {
            this.logger.severe("Firmware must be greater than 2.50.00");
            throw new UnsupportedOperationException("Firmware must be greater than 2.50.00");
        }
        this.irradianceCalibrationFactor.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradianceCalibrationFactor.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradianceCalibrationFactor.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradianceCalibrationFactor.setCollectionArea(area);
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime() * 1024 / 1000;
    }

    public void setStrobeDelay(int delay) throws IOException {
        if (!this.flGatedFW) {
            return;
        }
        this.setGateFrequency(delay);
        this.strobeDelay = delay;
    }

    public int getStrobeDelay() {
        return this.strobeDelay;
    }

    public String getName() {
        String name = USBProductInfo.getProductInfo((int)this.vendorID, (int)this.productID).name;
        if (this.flGatedFW) {
            name = this.curie ? "Curie" : name + "-FLG";
        }
        return name;
    }

    public byte[] getSPIBytes(byte[] message, int length) throws IOException {
        return this.spiBus.getSPIBytes(message, length);
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        if (this.firmwareVersionNumber > 1003000) {
            return this.plugInProvider.getPlugIns();
        }
        return null;
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        return this.i2cBus.setI2CBytes(address, numBytes, i2C);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        return this.i2cBus.getI2CBytes(address, numBytes);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }

    public int getGateIncrement() {
        return this.flGated.getGateIncrement();
    }

    public int getGateMaximum() {
        return this.flGated.getGateMaximum();
    }

    public int getGateMinimum() {
        return this.flGated.getGateMinimum();
    }

    public void setGateFrequency(int freq) throws IOException {
        this.flGated.setGateFrequency(freq);
    }

    public int getGateFrequency() {
        return this.strobeDelay;
    }

    public void addGateDelayListener(GateDelayListener listener) {
        this.flGated.addGateDelayListener(listener);
    }

    public void removeGateDelayListener(GateDelayListener listener) {
        this.flGated.removeGateDelayListener(listener);
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

