/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.usb650;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplNonFPGA;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImplNonFPGA;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRate;
import com.oceanoptics.omnidriver.features.masterclockrate.MasterClockRateImpl_ADC;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplNonFPGA;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusGUIProvider;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImplNonFPGA;
import com.oceanoptics.omnidriver.features.statusprovider.StatusProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.SpectrometerInfo;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.spam.numericalmethods.NumericalMethods;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import com.oceanoptics.utilities.DoubleArrayManipulation;
import java.io.File;
import java.io.IOException;

public class USB650
extends USBSpectrometer
implements HardwareTrigger,
StatusProvider,
PlugInProvider,
MasterClockRate,
IrradianceCalibrationFactor,
SPIBus,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
Version,
USBEndpointDevice {
    private static final int BAD_PIXELS_SLOT = 17;
    private static final int TOTAL_PIXELS = 2048;
    private static final int FINE_PIXELS = 6521;
    private static final int NUMBER_OF_PIXELS = 651;
    private double[] actualWavelength = new double[2048];
    private double[] actualIntensity = new double[2048];
    private double[] fineWavelength = new double[6521];
    private double[] fineIntensity = new double[6521];
    private double[] interpolatedWavelength = new double[651];
    private double[] interpolatedIntensity = new double[651];
    private int[] badPixels;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    NumericalMethods nm = new NumericalMethods();
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private PlugInProvider plugInProvider;
    private MasterClockRate masterClockRate;
    private IrradianceCalibrationFactorGUIProvider irradianceCalibrationFactor;
    private HardwareTriggerImpl hardwareTrigger;
    private SPIBusGUIProvider spiBus;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationGUIProvider wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private VersionGUIProvider version;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\ngetNumberOfPixels,()I\ngetNumberOfDarkPixels,()I\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nopenSpectrometer,(I)V\ngetChannels,()[Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\nsetMasterClock,(I)V\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\ngetActualIntegrationTime,()I\ngetSPIBytes,([BI)[B\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nisPlugInDetected,(I)Z\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\ninitializePlugIns,()[B\ndetectPlugIns,()V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\ntoString,()Ljava/lang/String;\n";

    public USB650() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public USB650(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public int getNumberOfPixels() {
        return 651;
    }

    public int getNumberOfDarkPixels() {
        return 0;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public void openSpectrometer(int index) throws IOException {
        int i;
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 651;
        this.numberOfDarkCCDPixels = 0;
        this.maxIntensity = 4095;
        this.pipeSize = 4097;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 4116;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.readSpectrum();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new Configuration(this);
        Coefficients coef = new Coefficients(this.channels[this.channelIndex].getCoefficients());
        this.channels[this.channelIndex].generateMetadata(this.spectrumBase, this.channelIndex);
        for (i = 0; i < 2048; ++i) {
            double dp = i;
            this.actualWavelength[i] = coef.getWlIntercept() + dp * coef.getWlFirst() + dp * dp * coef.getWlSecond() + dp * dp * dp * coef.getWlThird();
        }
        if (coef.getWlIntercept() < 210.0) {
            coef.setWlIntercept(200.0);
            coef.setWlFirst(1.0);
            coef.setWlSecond(0.0);
            coef.setWlThird(0.0);
        } else {
            coef.setWlIntercept(350.0);
            coef.setWlFirst(1.0);
            coef.setWlSecond(0.0);
            coef.setWlThird(0.0);
        }
        this.numberOfCCDPixels = 651;
        this.channels[0].setCoefficients(coef);
        this.channels[this.channelIndex].generateMetadata(this.spectrumBase, this.channelIndex);
        if (this.actualWavelength[0] > 210.0) {
            for (i = 0; i < 651; ++i) {
                this.interpolatedWavelength[i] = 350.0 + (double)i * 1.0;
            }
            for (i = 0; i < 6521; ++i) {
                this.fineWavelength[i] = 349.0 + (double)i * 0.1;
            }
        } else {
            for (i = 0; i < 651; ++i) {
                this.interpolatedWavelength[i] = 200.0 + (double)i * 1.0;
            }
            for (i = 0; i < 6521; ++i) {
                this.fineWavelength[i] = 199.0 + (double)i * 0.1;
            }
        }
        this.logger.fine("USB650 has been opened at index " + index);
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i].generateMetadata(this.spectrumBase, i);
        }
    }

    public SpectrometerChannel[] getChannels() {
        this.logger.fine("Channels: " + this.channels);
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int[] getBadPixelsFromDevice() {
        String strBadPixels;
        byte[] inarray = new byte[256];
        try {
            strBadPixels = super.getInfo(17);
            for (int i = 0; i < 4; ++i) {
                byte[] byArray = this.out;
                // MONITORENTER : this.out
                this.out[0] = 109;
                this.out[1] = (byte)(i * 64);
                this.out[2] = 0;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                // MONITOREXIT : byArray
                byArray = this.in;
                // MONITORENTER : this.in
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 64);
                System.arraycopy(this.in, 0, inarray, 64 * i, 64);
                // MONITOREXIT : byArray
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        int[] pix = null;
        int numBadPixels = 0;
        try {
            numBadPixels = Integer.parseInt(strBadPixels);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Failed to parse number of bad pixels");
            return new int[0];
        }
        if (numBadPixels <= 0) return pix;
        try {
            pix = new int[Integer.parseInt(strBadPixels)];
        }
        catch (NumberFormatException nfe) {
            return new int[0];
        }
        int i = 0;
        while (i < numBadPixels) {
            pix[i] = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)inarray[2 * i + 1], (byte)inarray[2 * i]);
            ++i;
        }
        return pix;
    }

    protected void finishConstruction() throws IOException {
        this.getScoreboard()[this.deviceIndex] = this;
        this.badPixels = this.getBadPixelsFromDevice();
        this.getCoefficientsFromSpectrometer();
        try {
            SpectrometerPlugIn[] plugins;
            Class[] pluginClasses = null;
            if (this instanceof PlugInProvider && null != (plugins = this.getPlugIns())) {
                pluginClasses = new Class[plugins.length];
                for (int i = 0; i < plugins.length; ++i) {
                    pluginClasses[i] = plugins[i].getClass();
                }
            }
            this.spectrumBase = new SpectrometerInfo(this.getSerialNumber(), this.getFirmwareVersion(), this.getClass(), pluginClasses, this.numChannels, this.getNumberOfPixels(0), this.getNumberOfDarkPixels(0), this.getMaxIntensity(), this.getIntegrationTimeMinimum(), this.getIntegrationTimeMaximum(), this.getIntegrationTimeIncrement(), this.getIntegrationTimeBase());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        try {
            this.logger.finest("Formatting spectrum...");
            doubleSpectrum.setSaturated(false);
            byte zero = 0;
            if (data[4096] != 105) {
                this.logger.severe("Lost synchronization");
                throw new IOException("Lost synchronization");
            }
            for (int i = 0; i < 2048; ++i) {
                int LSBPacket = i >> 6;
                int MSBPacket = LSBPacket + 1;
                byte MSB = data[(MSBPacket << 6) + i];
                byte LSB = data[(LSBPacket << 6) + i];
                int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
                if (pixel >= this.maxIntensity) {
                    doubleSpectrum.setSaturated(true);
                }
                this.actualIntensity[i] = pixel;
            }
            this.deleteBadPixels();
            this.interpolateSpectrum();
            doubleSpectrum.setSpectrum(this.interpolatedIntensity);
        }
        catch (Exception e) {
            System.err.println("Exception in format data of USB650");
        }
        return doubleSpectrum;
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.plugInProvider = new PlugInProviderImplNonFPGA(usb, this);
        this.masterClockRate = new MasterClockRateImpl_ADC(usb);
        this.irradianceCalibrationFactor = new IrradianceCalibrationFactorImplNonFPGA(usb, this.numberOfCCDPixels);
        this.hardwareTrigger = new HardwareTriggerImplNonFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(3)});
        this.spiBus = new SPIBusImplNonFPGA(usb);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        this.featureMap.put(MasterClockRateImpl_ADC.class, (MasterClockRateImpl_ADC)this.masterClockRate);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(SPIBusImpl.class, (SPIBusImpl)this.spiBus);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.spiBus, this.version};
    }

    private int[] getInvalidPixels() throws IOException {
        return this.badPixels;
    }

    private void deleteBadPixels() throws IOException {
        DoubleArrayManipulation.removeElements((double[])this.actualIntensity, (int[])this.badPixels);
        DoubleArrayManipulation.removeElements((double[])this.actualWavelength, (int[])this.badPixels);
    }

    private double[] interpolateSpectrum() throws IOException {
        this.interpolatedIntensity = this.nm.cubicSpline(this.actualWavelength, this.actualIntensity, this.interpolatedWavelength);
        return this.interpolatedIntensity;
    }

    public SpectrometerStatus getStatus() throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 41, 0)) {
            throw new UnsupportedOperationException("Firmware must be greater than 2.41.00");
        }
        byte[] sb = this.getStatusArray();
        SpectrometerStatus stat = new SpectrometerStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[0], (byte)sb[1]);
        stat.integrationTime = ByteRoutines.makeWord((byte)sb[2], (byte)sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7] == 0 ? 16 : 8;
        stat.dataReady = sb[8] != 0;
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        SpectrometerStatus stat = this.getStatus();
        return stat.integrationTime;
    }

    public void setMasterClock(int freq) throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 50, 0)) {
            this.logger.severe("Firmware must be greater than 2.50.00");
            throw new UnsupportedOperationException("Firmware must be greater than 2.50.00");
        }
        this.masterClockRate.setMasterClock(freq);
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 50, 0)) {
            this.logger.severe("Firmware must be greater than 2.50.00");
            throw new UnsupportedOperationException("Firmware must be greater than 2.50.00");
        }
        double[] ir = this.irradianceCalibrationFactor.getIrradianceCalibrationFactors();
        return ir;
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(2, 50, 0)) {
            this.logger.severe("Firmware must be greater than 2.50.00");
            throw new UnsupportedOperationException("Firmware must be greater than 2.50.00");
        }
        this.irradianceCalibrationFactor.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradianceCalibrationFactor.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradianceCalibrationFactor.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradianceCalibrationFactor.setCollectionArea(area);
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime() * 1024 / 1000;
    }

    public byte[] getSPIBytes(byte[] message, int length) throws IOException {
        return this.spiBus.getSPIBytes(message, length);
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        return this.plugInProvider.getPlugIns();
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

