/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.spectralprocessing;

import com.oceanoptics.highrestiming.HighResTimeStamp;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.interfaces.SpectrumConsumer;
import com.oceanoptics.omnidriver.interfaces.SpectrumProducer;
import com.oceanoptics.omnidriver.spectra.OmniSpectrum;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrumHandler;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.hr4000.HR4000;
import com.oceanoptics.omnidriver.spectrometer.maya2000.Maya2000;
import com.oceanoptics.omnidriver.spectrometer.mayapro2000.MayaPro2000;
import com.oceanoptics.omnidriver.spectrometer.qe65000.QE65000;
import com.oceanoptics.spam.numericalmethods.NumericalMethods;
import java.io.IOException;

public class SpectralProcessor
extends SpectrumHandler
implements SpectrumConsumer,
SpectrumProducer {
    private int numSpectraAccumulated;
    private double[] spectrumPixels;
    private double[] accumulatorSpectrumPixels;
    protected boolean stop;
    private Spectrum accumulator;
    private Spectrum averagedSpectrum;
    private int scansToAverage = 1;
    protected boolean stopAverage;
    private boolean correctForDetectorNonlinearity;
    private int smoothingWindowSize;
    private boolean correctForElectricalDark;
    private boolean electricalDarkCorrectionCompatabilityMode;
    private boolean correctForStrayLight;
    private SpectrometerChannel spectrometerChannel;
    private Coefficients coefficients;
    private double nlCoeff0;
    private double nlCoeff1;
    private double nlCoeff2;
    private double nlCoeff3;
    private double nlCoeff4;
    private double nlCoeff5;
    private double nlCoeff6;
    private double nlCoeff7;
    private int nlOrder;
    private double[] smoothingWindowWeights = null;
    private boolean automaticallyToggleStrobeEnable = false;
    private boolean generateEvent;
    private boolean strobeEnable = false;
    private int strobeDelay = 0;
    private int integrationTime = 3000;
    private double[] electricalDarkBuffer;
    private int electricalDarkBufferSize = 15;
    private int electricalDarkBufferSlotsFilled = 0;
    private int electricalDarkBufferLocation = 0;
    private int externalTriggerMode = 0;
    private String userName;
    private OmniSpectrum darkSpectrum = null;
    ProcessingThread processingThread = null;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;Z)V\ndestroyProcessor,()V\ngetOmniSpectrum,()Lcom/oceanoptics/omnidriver/spectra/OmniSpectrum;\nsetTimeout,(I)I\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrumRaw,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nprocessSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\nstopAveraging,()V\nboxcarAverage,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\ncorrectForStrayLight,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\ncorrectForStrayLightRaw,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\ncorrectForElectricalDarkSignal,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\nhasNonlinearityCorrectionCoefficients,()Z\ncorrectForDetectorNonlinearity,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)V\ngetScansToAverage,()I\nsetScansToAverage,(I)V\nisCorrectForDetectorNonlinearity,()Z\nsetCorrectForDetectorNonlinearity,(Z)V\ngetSmoothingWindowSize,()I\nsetSmoothingWindowSize,(I)V\nisCorrectForElectricalDark,()Z\nsetCorrectForElectricalDark,(Z)V\nsetCorrectForElectricalDark,(ZZ)V\nisCorrectForStrayLight,()Z\nsetCorrectForStrayLight,(Z)V\ngetSmoothingWindowWeights,()[D\nsetSmoothingWindowWeights,([D)V\nsetDarkSpectrum,(Lcom/oceanoptics/omnidriver/spectra/OmniSpectrum;)V\ngetExternalTriggerMode,()I\nsetExternalTriggerMode,(I)V\ngetIntegrationTime,()I\nsetIntegrationTime,(I)V\ngetStrobeEnable,()Z\ngetAutoToggleStrobeLampEnable,()Z\nsetStrobeEnable,(Z)V\nsetAutoToggleStrobeLampEnable,(Z)V\ngetStrobeDelay,()I\nsetStrobeDelay,(I)V\nsetParameters,(IZZZIIZIIZ)V\ngetSpectrometerChannel,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerChannel;\nattachSource,(Lcom/oceanoptics/omnidriver/spectrometer/SpectrumHandler;)V\ndetachSource,()V\nstop,()V\nfinalize,()V\n";

    public SpectralProcessor(SpectrometerChannel channel, boolean daemon) throws IOException {
        super(channel.getNumberOfPixels(), channel.getNumberOfDarkPixels());
        this.spectrometerChannel = channel;
        this.setSource(channel);
        if (this.spectrometerChannel.getCoefficients() instanceof Coefficients) {
            this.coefficients = this.spectrometerChannel.getCoefficients();
        }
        this.userName = System.getProperty("user.name");
        this.fixNumberOfPixels();
        if (daemon) {
            this.processingThread = new ProcessingThread("SpectralProcessor.ProcessingThread");
            this.processingThread.setDaemon(true);
            this.processingThread.start();
        }
        this.electricalDarkCorrectionCompatabilityMode = true;
        this.electricalDarkBufferSlotsFilled = 0;
    }

    public void destroyProcessor() {
        this.removeSource(this.spectrometerChannel);
        this.spectrometerChannel = null;
        this.accumulatorSpectrumPixels = null;
        this.accumulator = null;
    }

    public OmniSpectrum getOmniSpectrum() throws IOException {
        Spectrum ds = this.getSpectrum(null);
        if (ds == null) {
            return null;
        }
        if (null == this.getSpectrometerChannel() || null == this.getSpectrometerChannel().getSpectrometerChannelInfo()) {
            return null;
        }
        OmniSpectrum rps = new OmniSpectrum(this.getSpectrometerChannel().getSpectrometerChannelInfo(), ds.getSpectrum(), ds.isSaturated(), this.getIntegrationTime(), new HighResTimeStamp(), this.getSmoothingWindowSize(), this.getScansToAverage(), this.isCorrectForElectricalDark(), this.isCorrectForDetectorNonlinearity(), this.isCorrectForStrayLight(), this.getStrobeEnable(), this.getStrobeDelay(), false, this.userName);
        return rps;
    }

    public int setTimeout(int timeoutMilliseconds) {
        Spectrometer spectrometer = this.spectrometerChannel.getSpectrometer();
        if (spectrometer instanceof USBSpectrometer) {
            return ((USBSpectrometer)spectrometer).setTimeout(timeoutMilliseconds);
        }
        return -1;
    }

    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        boolean usingStoredDark = false;
        boolean saturated = false;
        this.stopAverage = false;
        Spectrometer spectrometer = this.spectrometerChannel.getSpectrometer();
        if (0 == this.numberOfDarkPixels && null != this.darkSpectrum && (this.correctForDetectorNonlinearity || this.correctForStrayLight)) {
            usingStoredDark = true;
        }
        this.coefficients = this.spectrometerChannel.getCoefficients();
        spectrometer.setIntegrationTime(this.getIntegrationTime());
        if (this.strobeEnable && this.automaticallyToggleStrobeEnable) {
            spectrometer.setStrobeEnable(true);
            Spectrum stabilityScan = this.spectrometerChannel.getSpectrum();
            stabilityScan = null;
        } else {
            spectrometer.setStrobeEnable(this.getStrobeEnable());
        }
        if (spectrometer instanceof HardwareTrigger) {
            ((HardwareTrigger)((Object)spectrometer)).setExternalTriggerMode(this.getExternalTriggerMode());
        }
        this.fixNumberOfPixels();
        if (spectrum == null || spectrum.getSpectrum().length != this.numberOfPixels) {
            spectrum = this.getUnfilledSpectrum(this.numberOfPixels, this.numberOfDarkPixels);
        }
        for (int i = 0; i < this.scansToAverage; ++i) {
            if (!this.stopAverage) {
                Spectrum is = this.spectrometerChannel.getSpectrum();
                if (is == null) {
                    return null;
                }
                this.accumulate(is);
                if (!is.isSaturated()) continue;
                saturated = true;
                continue;
            }
            this.stopAverage = false;
            this.scansToAverage = 1;
            return spectrum;
        }
        spectrum.setSaturated(saturated);
        this.divide(spectrum);
        if (usingStoredDark) {
            this.subtractDark(spectrum, this.darkSpectrum);
        } else if (this.correctForElectricalDark) {
            this.correctForElectricalDarkSignal(spectrum);
        }
        if (this.correctForDetectorNonlinearity) {
            this.correctForDetectorNonlinearity(spectrum);
        }
        if (this.correctForStrayLight) {
            this.correctForStrayLight(spectrum);
        }
        if (usingStoredDark) {
            this.addDark(spectrum, this.darkSpectrum);
        }
        if (this.smoothingWindowSize > 0) {
            this.boxcarAverage(spectrum);
        }
        if (this.automaticallyToggleStrobeEnable) {
            spectrometer.setStrobeEnable(false);
        }
        return spectrum;
    }

    public Spectrum getSpectrumRaw(Spectrum spectrum) throws IOException {
        boolean saturated = false;
        this.stopAverage = false;
        Spectrometer spectrometer = this.spectrometerChannel.getSpectrometer();
        this.coefficients = this.spectrometerChannel.getCoefficients();
        spectrometer.setIntegrationTime(this.getIntegrationTime());
        if (this.strobeEnable && this.automaticallyToggleStrobeEnable) {
            spectrometer.setStrobeEnable(true);
            Spectrum stabilityScan = this.spectrometerChannel.getSpectrumRaw();
            stabilityScan = null;
        } else {
            spectrometer.setStrobeEnable(this.getStrobeEnable());
        }
        if (spectrometer instanceof HardwareTrigger) {
            ((HardwareTrigger)((Object)spectrometer)).setExternalTriggerMode(this.getExternalTriggerMode());
        }
        if (spectrum == null || spectrum.getSpectrum().length != this.spectrometerChannel.getNumberOfRawPixels()) {
            spectrum = this.getUnfilledSpectrum(spectrometer.getNumberOfRawPixels(), this.numberOfDarkPixels);
        }
        for (int i = 0; i < this.scansToAverage; ++i) {
            if (!this.stopAverage) {
                Spectrum is = this.spectrometerChannel.getSpectrumRaw();
                if (is == null) {
                    return null;
                }
                spectrum.setSpectrum(is.getSpectrum());
                if (!is.isSaturated()) continue;
                saturated = true;
                continue;
            }
            this.stopAverage = false;
            this.scansToAverage = 1;
            return spectrum;
        }
        spectrum.setSaturated(saturated);
        if (this.correctForDetectorNonlinearity) {
            this.correctForDetectorNonlinearity(spectrum);
        }
        if (this.correctForStrayLight) {
            this.correctForStrayLightRaw(spectrum);
        }
        if (this.automaticallyToggleStrobeEnable) {
            spectrometer.setStrobeEnable(false);
        }
        return spectrum;
    }

    public void processSpectrum(Spectrum spectrum) {
        boolean usingStoredDark = false;
        if (null != this.darkSpectrum && (this.correctForDetectorNonlinearity || this.correctForStrayLight)) {
            usingStoredDark = true;
        }
        this.coefficients = this.spectrometerChannel.getCoefficients();
        try {
            this.spectrometerChannel.getSpectrometer().setStrobeEnable(this.getStrobeEnable());
            this.spectrometerChannel.getSpectrometer().setIntegrationTime(this.getIntegrationTime());
            ((HardwareTrigger)((Object)this.spectrometerChannel.getSpectrometer())).setExternalTriggerMode(this.getExternalTriggerMode());
        }
        catch (IOException io) {
            // empty catch block
        }
        this.spectrumPixels = spectrum.getSpectrum();
        if (this.scansToAverage == 1) {
            this.averagedSpectrum = this.getUnfilledSpectrum();
            double[] averagedSpectrumPixels = this.averagedSpectrum.getSpectrum();
            for (int i = 0; i < this.numberOfPixels; ++i) {
                averagedSpectrumPixels[i] = this.spectrumPixels[i];
            }
            this.generateEvent = true;
        } else {
            if (this.numSpectraAccumulated < this.scansToAverage - 1) {
                if (this.numSpectraAccumulated == 0) {
                    this.averagedSpectrum = this.getUnfilledSpectrum();
                }
                this.accumulate(spectrum);
                ++this.numSpectraAccumulated;
                return;
            }
            this.divide(this.averagedSpectrum);
            this.numSpectraAccumulated = 0;
            this.generateEvent = true;
        }
        if (usingStoredDark) {
            this.subtractDark(spectrum, this.darkSpectrum);
        } else if (this.correctForElectricalDark) {
            this.correctForElectricalDarkSignal(spectrum);
        }
        if (this.correctForDetectorNonlinearity) {
            this.correctForDetectorNonlinearity(this.averagedSpectrum);
        }
        if (this.correctForStrayLight) {
            this.correctForStrayLight(this.averagedSpectrum);
        }
        if (usingStoredDark) {
            this.addDark(spectrum, this.darkSpectrum);
        }
        if (this.smoothingWindowSize > 0) {
            this.boxcarAverage(this.averagedSpectrum);
        }
    }

    public void stopAveraging() {
        this.stopAverage = true;
    }

    private void accumulate(Spectrum spectrum) {
        this.spectrumPixels = spectrum.getSpectrum();
        try {
            for (int i = this.spectrumPixels.length - 1; i >= 0; --i) {
                int n = i;
                this.accumulatorSpectrumPixels[n] = this.accumulatorSpectrumPixels[n] + this.spectrumPixels[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.fixNumberOfPixels();
            this.scansToAverage = 1;
            System.out.println("Restarting " + this.scansToAverage + " scans to average.");
        }
    }

    private void divide(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = this.accumulatorSpectrumPixels[i] / (double)this.scansToAverage;
        }
    }

    public void boxcarAverage(Spectrum spectrum) {
        double count = 2 * this.smoothingWindowSize + 1;
        double[] pixels = spectrum.getSpectrum();
        double[] temp = new double[pixels.length];
        System.arraycopy(pixels, 0, temp, 0, pixels.length);
        if (this.smoothingWindowWeights == null) {
            int end = pixels.length;
            for (int i = this.smoothingWindowSize; i < end - this.smoothingWindowSize; ++i) {
                double sum = 0.0;
                for (int j = -this.smoothingWindowSize; j < this.smoothingWindowSize + 1; ++j) {
                    sum += temp[i + j];
                }
                pixels[i] = sum /= 2.0 * (double)this.smoothingWindowSize + 1.0;
            }
            spectrum.setSpectrum(pixels);
        }
    }

    public void correctForStrayLight(Spectrum spectrum) {
        double intensity = this.spectrometerChannel.getMaxIntensity() * this.spectrometerChannel.getNumberOfPixels();
        double[] pixels = spectrum.getSpectrum();
        double sum = pixels[0];
        for (int i = pixels.length - 1; i > 0; --i) {
            sum += pixels[i];
        }
        double correction = this.coefficients.getStrayLight() * sum / intensity;
        double slope = this.coefficients.getStrayLightSlope();
        for (int i = pixels.length - 1; i >= 0; --i) {
            int n = i;
            pixels[n] = pixels[n] - (correction + slope * (double)i * sum / intensity);
        }
    }

    public void correctForStrayLightRaw(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        double intensity = this.spectrometerChannel.getMaxIntensity() * pixels.length;
        double sum = pixels[0];
        for (int i = pixels.length - 1; i > 0; --i) {
            sum += pixels[i];
        }
        double correction = this.coefficients.getStrayLight() * sum / intensity;
        double slope = this.coefficients.getStrayLightSlope();
        for (int i = pixels.length - 1; i >= 0; --i) {
            int n = i;
            pixels[n] = pixels[n] - (correction + slope * (double)i * sum / intensity);
        }
    }

    private void doCorrectForElectricalDarkHR4000(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        double avgDark = 0.0;
        avgDark += pixels[5];
        avgDark += pixels[6];
        avgDark += pixels[7];
        avgDark += pixels[8];
        avgDark += pixels[9];
        avgDark += pixels[10];
        avgDark += pixels[11];
        avgDark += pixels[12];
        avgDark += pixels[13];
        avgDark += pixels[14];
        avgDark += pixels[15];
        avgDark += pixels[16];
        avgDark += pixels[17];
        this.applyElectricalDarkCorrection(avgDark /= 13.0, pixels);
    }

    private void doCorrectForElectricalDarkMaya2000(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        double avgDark = 0.0;
        int darkPixelCount = 0;
        avgDark += pixels[0];
        ++darkPixelCount;
        avgDark += pixels[1];
        ++darkPixelCount;
        avgDark += pixels[2];
        ++darkPixelCount;
        avgDark += pixels[3];
        ++darkPixelCount;
        avgDark += pixels[4];
        ++darkPixelCount;
        avgDark += pixels[5];
        ++darkPixelCount;
        avgDark += pixels[6];
        ++darkPixelCount;
        avgDark += pixels[7];
        ++darkPixelCount;
        avgDark += pixels[2072];
        ++darkPixelCount;
        avgDark += pixels[2073];
        ++darkPixelCount;
        avgDark += pixels[2074];
        ++darkPixelCount;
        avgDark += pixels[2075];
        ++darkPixelCount;
        avgDark += pixels[2076];
        ++darkPixelCount;
        avgDark += pixels[2077];
        ++darkPixelCount;
        avgDark += pixels[2078];
        ++darkPixelCount;
        avgDark += pixels[2079];
        this.applyElectricalDarkCorrection(avgDark /= (double)(++darkPixelCount), pixels);
    }

    private void doCorrectForElectricalDarkMayaPro2000(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        double avgDark = 0.0;
        avgDark += pixels[0];
        avgDark += pixels[1];
        avgDark += pixels[2];
        avgDark += pixels[3];
        avgDark += pixels[2064];
        avgDark += pixels[2065];
        avgDark += pixels[2066];
        avgDark += pixels[2067];
        this.applyElectricalDarkCorrection(avgDark /= 8.0, pixels);
    }

    private void doCorrectForElectricalDarkQE65000(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        double avgDark = 0.0;
        for (int i = 1025; i <= 1027; ++i) {
            double pixel = pixels[i];
            avgDark += pixel;
        }
        this.applyElectricalDarkCorrection(avgDark /= 3.0, pixels);
    }

    public void correctForElectricalDarkSignal(Spectrum spectrum) {
        if (null == this.electricalDarkBuffer) {
            this.electricalDarkBuffer = new double[this.electricalDarkBufferSize];
            for (int ii = 0; ii < this.electricalDarkBufferSize; ++ii) {
                this.electricalDarkBuffer[ii] = 0.0;
                this.electricalDarkBufferLocation = 0;
            }
        }
        if (this.spectrometerChannel.getSpectrometer() instanceof HR4000) {
            this.doCorrectForElectricalDarkHR4000(spectrum);
            return;
        }
        if (this.spectrometerChannel.getSpectrometer() instanceof QE65000) {
            this.doCorrectForElectricalDarkQE65000(spectrum);
            return;
        }
        if (this.spectrometerChannel.getSpectrometer() instanceof MayaPro2000) {
            this.doCorrectForElectricalDarkMayaPro2000(spectrum);
            return;
        }
        if (this.spectrometerChannel.getSpectrometer() instanceof Maya2000) {
            this.doCorrectForElectricalDarkMaya2000(spectrum);
            return;
        }
        double[] pixels = spectrum.getSpectrum();
        int numDarkPixels = spectrum.getNumberOfDarkPixels();
        if (numDarkPixels < 3) {
            return;
        }
        double avgDark = 0.0;
        for (int i = 2; i < numDarkPixels; ++i) {
            double pixel = pixels[i];
            avgDark += pixel;
        }
        this.applyElectricalDarkCorrection(avgDark /= (double)(numDarkPixels - 2), pixels);
        pixels[0] = pixels[1];
    }

    private void applyElectricalDarkCorrection(double averageDarkPixelValue, double[] pixels) {
        if (this.electricalDarkCorrectionCompatabilityMode) {
            this.electricalDarkBuffer[this.electricalDarkBufferLocation] = averageDarkPixelValue;
            double ringBufferAverage = NumericalMethods.average((double[])this.electricalDarkBuffer);
            ++this.electricalDarkBufferLocation;
            if (this.electricalDarkBufferLocation == this.electricalDarkBufferSize) {
                this.electricalDarkBufferLocation = 0;
            }
            int index = 1;
            while (index < pixels.length) {
                int n = index++;
                pixels[n] = pixels[n] - ringBufferAverage;
            }
        } else {
            this.electricalDarkBuffer[this.electricalDarkBufferLocation] = averageDarkPixelValue;
            ++this.electricalDarkBufferSlotsFilled;
            if (this.electricalDarkBufferSlotsFilled > this.electricalDarkBufferSize) {
                this.electricalDarkBufferSlotsFilled = this.electricalDarkBufferSize;
            }
            double ringBufferAverage = NumericalMethods.average((double[])this.electricalDarkBuffer, (int)0, (int)(this.electricalDarkBufferSlotsFilled - 1));
            ++this.electricalDarkBufferLocation;
            if (this.electricalDarkBufferLocation == this.electricalDarkBufferSize) {
                this.electricalDarkBufferLocation = 0;
            }
            int index = 1;
            while (index < pixels.length) {
                int n = index++;
                pixels[n] = pixels[n] - ringBufferAverage;
            }
        }
    }

    public boolean hasNonlinearityCorrectionCoefficients() {
        double sum = this.coefficients.getNlCoef0();
        sum += this.coefficients.getNlCoef1();
        sum += this.coefficients.getNlCoef2();
        sum += this.coefficients.getNlCoef3();
        sum += this.coefficients.getNlCoef4();
        if (this.coefficients.getNlOrder() == 7) {
            sum += this.coefficients.getNlCoef5();
            sum += this.coefficients.getNlCoef6();
            sum += this.coefficients.getNlCoef7();
        }
        return sum != 0.0;
    }

    public void correctForDetectorNonlinearity(Spectrum spectrum) {
        double[] pixels = spectrum.getSpectrum();
        this.nlCoeff0 = this.coefficients.getNlCoef0();
        this.nlCoeff1 = this.coefficients.getNlCoef1();
        this.nlCoeff2 = this.coefficients.getNlCoef2();
        this.nlCoeff3 = this.coefficients.getNlCoef3();
        this.nlCoeff4 = this.coefficients.getNlCoef4();
        this.nlCoeff5 = this.coefficients.getNlCoef5();
        this.nlCoeff6 = this.coefficients.getNlCoef6();
        this.nlCoeff7 = this.coefficients.getNlCoef7();
        for (int i = 0; i < pixels.length; ++i) {
            double pixel;
            double factor = this.nlCoeff0;
            double accumulator = pixel = pixels[i];
            factor += accumulator * this.nlCoeff1;
            factor += (accumulator *= pixel) * this.nlCoeff2;
            factor += (accumulator *= pixel) * this.nlCoeff3;
            factor += (accumulator *= pixel) * this.nlCoeff4;
            accumulator *= pixel;
            if (this.coefficients.getNlOrder() == 7) {
                factor += accumulator * this.nlCoeff5;
                factor += (accumulator *= pixel) * this.nlCoeff6;
                factor += (accumulator *= pixel) * this.nlCoeff7;
            }
            pixels[i] = pixel / factor;
        }
    }

    public int getScansToAverage() {
        return this.scansToAverage;
    }

    public void setScansToAverage(int scansToAverage) {
        if (scansToAverage < 1) {
            scansToAverage = 1;
        }
        this.scansToAverage = scansToAverage;
    }

    public boolean isCorrectForDetectorNonlinearity() {
        return this.correctForDetectorNonlinearity;
    }

    public void setCorrectForDetectorNonlinearity(boolean correctForDetectorNonlinearity) {
        if (this.coefficients == null && correctForDetectorNonlinearity) {
            return;
        }
        this.correctForDetectorNonlinearity = correctForDetectorNonlinearity;
    }

    public int getSmoothingWindowSize() {
        return this.smoothingWindowSize;
    }

    public void setSmoothingWindowSize(int newSmoothingWindowSize) {
        this.smoothingWindowSize = newSmoothingWindowSize;
    }

    public boolean isCorrectForElectricalDark() {
        return this.correctForElectricalDark;
    }

    public void setCorrectForElectricalDark(boolean correctForElectricalDark) {
        this.electricalDarkCorrectionCompatabilityMode = true;
        this.correctForElectricalDark = correctForElectricalDark;
    }

    public void setCorrectForElectricalDark(boolean correctForElectricalDark, boolean compatabilityMode) {
        this.electricalDarkCorrectionCompatabilityMode = compatabilityMode;
        this.correctForElectricalDark = correctForElectricalDark;
    }

    public boolean isCorrectForStrayLight() {
        return this.correctForStrayLight;
    }

    public void setCorrectForStrayLight(boolean correctForStrayLight) {
        if (this.coefficients == null && correctForStrayLight) {
            return;
        }
        this.correctForStrayLight = correctForStrayLight;
    }

    public double[] getSmoothingWindowWeights() {
        return this.smoothingWindowWeights;
    }

    public void setSmoothingWindowWeights(double[] smoothingWindowWeights) {
        if (smoothingWindowWeights.length > this.spectrometerChannel.getNumberOfPixels() / 2 - 1) {
            return;
        }
        this.smoothingWindowWeights = smoothingWindowWeights;
    }

    private void subtractDark(Spectrum spectrum, OmniSpectrum darkSpec) {
        double[] counts = spectrum.getSpectrum();
        double[] dark = darkSpec.getPixelValues();
        if (dark.length != counts.length) {
            return;
        }
        for (int i = 0; i < counts.length; ++i) {
            int n = i;
            counts[n] = counts[n] - dark[i];
        }
    }

    private void addDark(Spectrum spectrum, OmniSpectrum darkSpec) {
        double[] counts = spectrum.getSpectrum();
        double[] dark = darkSpec.getPixelValues();
        if (dark.length != counts.length) {
            return;
        }
        for (int i = 0; i < counts.length; ++i) {
            int n = i;
            counts[n] = counts[n] + dark[i];
        }
    }

    public void setDarkSpectrum(OmniSpectrum dark) {
        this.darkSpectrum = dark;
    }

    public int getExternalTriggerMode() {
        return this.externalTriggerMode;
    }

    public void setExternalTriggerMode(int mode) {
        this.externalTriggerMode = mode;
    }

    public int getIntegrationTime() {
        return this.integrationTime;
    }

    public void setIntegrationTime(int newIntegrationTime) {
        this.integrationTime = newIntegrationTime;
        this.electricalDarkBufferSlotsFilled = 0;
    }

    public boolean getStrobeEnable() {
        return this.strobeEnable;
    }

    public boolean getAutoToggleStrobeLampEnable() {
        return this.automaticallyToggleStrobeEnable;
    }

    public void setStrobeEnable(boolean enable) {
        this.strobeEnable = enable;
    }

    public void setAutoToggleStrobeLampEnable(boolean enable) {
        this.automaticallyToggleStrobeEnable = enable;
    }

    public int getStrobeDelay() {
        return this.strobeDelay;
    }

    public void setStrobeDelay(int newDelay) {
        this.strobeDelay = newDelay;
        try {
            this.spectrometerChannel.getSpectrometer().setStrobeDelay(newDelay);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setParameters(int sta, boolean ced, boolean cnl, boolean csl, int bcw, int it, boolean se, int sd, int etm, boolean atl) {
        this.setScansToAverage(sta);
        this.setCorrectForElectricalDark(ced);
        this.setCorrectForDetectorNonlinearity(cnl);
        this.setCorrectForStrayLight(csl);
        this.setSmoothingWindowSize(bcw);
        this.setIntegrationTime(it);
        this.setStrobeEnable(se);
        this.setStrobeDelay(sd);
        this.setExternalTriggerMode(etm);
        this.setAutoToggleStrobeLampEnable(atl);
    }

    protected void fixNumberOfPixels() {
        super.fixNumberOfPixels();
        this.numberOfPixels = this.spectrometerChannel.getNumberOfPixels();
        this.numberOfDarkPixels = this.spectrometerChannel.getNumberOfDarkPixels();
        this.accumulator = new Spectrum(this.spectrometerChannel.getNumberOfPixels(), this.spectrometerChannel.getNumberOfDarkPixels());
        this.accumulatorSpectrumPixels = this.accumulator.getSpectrum();
    }

    public SpectrometerChannel getSpectrometerChannel() {
        return this.spectrometerChannel;
    }

    public void attachSource(SpectrumHandler source) {
        this.setSource(source);
    }

    public void detachSource() {
        this.removeSource(this.spectrometerChannel);
        this.spectrometerChannel = null;
    }

    public void stop() {
        this.stop = true;
        if (this.processingThread != null) {
            this.processingThread.interrupt();
            this.processingThread = null;
        }
    }

    public void finalize() {
        this.stop();
        this.detachSource();
    }

    class ProcessingThread
    extends Thread {
        ProcessingThread(String name) {
            super(name);
        }

        public void run() {
            while (!SpectralProcessor.this.stop) {
                Spectrum spectrum = SpectralProcessor.this.getNextUnprocessedDoubleSpectrum();
                if (spectrum == null) continue;
                SpectralProcessor.this.processSpectrum(spectrum);
                if (!SpectralProcessor.this.generateEvent) continue;
                SpectralProcessor.this.fireSpectrumListenerNewSpectrum(SpectralProcessor.this.averagedSpectrum);
                SpectralProcessor.this.generateEvent = false;
            }
        }
    }
}

