/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.tests;

import com.oceanoptics.omnidriver.features.USBImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.OmniSpectrum;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000Channel;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000USB;
import com.oceanoptics.spectralprocessing.SpectralProcessor;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ADC1000USBTest {
    int numChannels = 0;
    USBInterface usb = new USBImpl();
    ADC1000USB s;
    public USBEndpointDescriptor dataOutEndPoint = null;
    public USBEndpointDescriptor highSpeedInEndPoint1 = null;
    public USBEndpointDescriptor highSpeedInEndPoint2 = null;
    public USBEndpointDescriptor lowSpeedInEndPoint = null;
    private static final int DATA_OUT = 2;
    private static final int HIGH_SPEED_DATA_IN = 130;
    private static final int UNUSED_DATA_OUT = 7;
    private static final int LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,()V\nsetEndpoints,()V\nrunDriverDependent,()V\nrunIndependent,()V\ninitialize,()V\ngetNumChannels,()I\nreadInfo,(I)Ljava/lang/String;\nsetRotatorTrue,()V\nsetChannelMux,(I)V\ngetSpectrum,()[D\nmain,([Ljava/lang/String;)V\n";

    public ADC1000USBTest() throws IOException {
        this.setEndpoints();
        this.runDriverDependent();
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, -126, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, -121, 2, 64, 0);
    }

    public void runDriverDependent() {
        try {
            int x;
            SpectrometerChannel c;
            int i;
            this.s = new ADC1000USB(0);
            this.numChannels = this.s.getNumberOfChannels();
            SpectrometerChannel[] channels = new ADC1000Channel[this.numChannels];
            channels = this.s.getChannels();
            int numEnabledChannels = this.s.getNumberOfEnabledChannels();
            System.out.println(this.s);
            System.out.println("");
            for (int i2 = 0; i2 < this.numChannels; ++i2) {
                System.out.println("Channel " + i2 + " present? " + this.s.isChannelPresent(i2));
            }
            System.out.println("Number of enabled channels: " + this.s.getNumberOfEnabledChannels());
            System.out.println("");
            this.s.setChannelPresent(1, true);
            SpectralProcessor[] processors = new SpectralProcessor[numEnabledChannels];
            System.out.println("\n\nValues from ADC1000Channel");
            for (i = 0; i < numEnabledChannels; ++i) {
                System.out.println("\nChannel " + i);
                c = channels[i];
                Spectrum spec = new Spectrum(c.getNumberOfPixels(), c.getNumberOfDarkPixels());
                spec = c.getSpectrum(spec);
                double[] pixs = spec.getSpectrum();
                for (x = 0; x < pixs.length; ++x) {
                    System.out.print(pixs[x] + " ");
                }
                System.out.println("\nPixels: " + x);
            }
            System.out.println("\n\nSpectralProcessor values");
            for (i = 0; i < numEnabledChannels; ++i) {
                System.out.println("\nChannel " + i);
                c = channels[i];
                processors[i] = new SpectralProcessor(c, false);
                processors[i].setIntegrationTime(100000);
                Spectrum spect = new Spectrum(c.getNumberOfPixels(), c.getNumberOfDarkPixels());
                spect = processors[i].getSpectrum(spect);
                double[] pixels = spect.getSpectrum();
                for (x = 0; x < pixels.length; ++x) {
                    System.out.print(pixels[x] + " ");
                }
                System.out.println("\nPixels: " + x);
            }
            System.out.println("\n\nOmniDriver values");
            for (i = 0; i < numEnabledChannels; ++i) {
                System.out.println("\nChannel " + i);
                c = channels[i];
                processors[i] = new SpectralProcessor(c, false);
                processors[i].setIntegrationTime(100000);
                OmniSpectrum d = processors[i].getOmniSpectrum();
                double[] spect = d.getPixelValues();
                for (x = 0; x < spect.length; ++x) {
                    System.out.print(spect[x] + " ");
                }
                System.out.println("\nPixels: " + x);
            }
            System.out.println("DAC Present: " + this.s.isDACPresent());
            if (this.s.isDACPresent()) {
                System.out.println("DAC counts " + this.s.getDACCounts(0));
                this.s.setDACCounts(4095, 0);
                System.out.println("DAC counts " + this.s.getDACCounts(0));
            }
            this.s.closeSpectrometer();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("An exception occured.");
        }
        System.out.println("end.");
    }

    public void runIndependent() {
        try {
            this.usb.openDevice(9303, 4100, 0);
            this.initialize();
            this.numChannels = this.getNumChannels();
            System.out.println("\n\nRaw values");
            for (int i = 0; i < this.numChannels; ++i) {
                int x;
                System.out.println("\nChannel " + i);
                this.setChannelMux(i);
                double[] sp = this.getSpectrum();
                for (x = 0; x < sp.length; ++x) {
                    System.out.print(sp[x] + " ");
                }
                System.out.println("\nPixels: " + x);
            }
            this.setChannelMux(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\nend.");
    }

    public void initialize() throws IOException {
        byte[] out = new byte[]{1};
        this.usb.bulkOut(this.dataOutEndPoint, out, 1);
    }

    public int getNumChannels() throws IOException {
        int channelVector = Integer.parseInt(this.readInfo(1));
        int num = 0;
        for (int i = 0; i < 8; ++i) {
            if ((channelVector >> i & 1) == 0) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readInfo(int slot) throws IOException {
        byte[] out = new byte[2];
        byte[] in = new byte[17];
        String strRet = "";
        byte[] byArray = out;
        synchronized (out) {
            byte[] byArray2 = in;
            synchronized (in) {
                out[0] = 5;
                out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)slot));
                this.usb.bulkOut(this.dataOutEndPoint, out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, in, 17);
                for (int i = 2; in[i] != 0 && i < 17; ++i) {
                    strRet = strRet + (char)in[i];
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
            return strRet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotatorTrue() throws IOException {
        byte[] out = new byte[3];
        int bitVector = 256;
        bitVector |= this.numChannels - 1;
        byte[] byArray = out;
        synchronized (out) {
            out[0] = 11;
            out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)bitVector));
            out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)bitVector));
            this.usb.bulkOut(this.dataOutEndPoint, out, 3);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelMux(int channel) throws IOException {
        byte[] out = new byte[3];
        int bitVector = channel;
        byte[] byArray = out;
        synchronized (out) {
            out[0] = 11;
            out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)bitVector));
            out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)bitVector));
            this.usb.bulkOut(this.dataOutEndPoint, out, 3);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public double[] getSpectrum() throws IOException {
        this.requestSpectrum();
        return this.formatData(this.readSpectrum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readSpectrum() throws IOException {
        byte[] rawData;
        byte[] byArray = rawData = new byte[4097];
        synchronized (rawData) {
            this.usb.bulkIn(this.highSpeedInEndPoint1, rawData, 4097);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSpectrum() throws IOException {
        byte[] out;
        byte[] byArray = out = new byte[1];
        synchronized (out) {
            out[0] = 9;
            this.usb.bulkOut(this.dataOutEndPoint, out, 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected double[] formatData(byte[] data) {
        double[] spectrum = new double[2048];
        byte zero = 0;
        for (int i = 0; i < spectrum.length; ++i) {
            int LSBPacket = i >> 6;
            int MSBPacket = LSBPacket + 1;
            byte LSB = data[(LSBPacket << 6) + i];
            byte MSB = data[(MSBPacket << 6) + i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            spectrum[i] = pixel;
        }
        return spectrum;
    }

    public static void main(String[] args) throws IOException {
        ADC1000USBTest t = new ADC1000USBTest();
    }
}

