/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.tests;

import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerFactory;
import java.io.IOException;

public class IrradCalTest {
    private static String __extern__ = "__extern__\n<init>,()V\nmain,([Ljava/lang/String;)V\n";

    public static void main(String[] args) {
        Spectrometer[] specs = SpectrometerFactory.getAllSpectrometers();
        System.out.println("Spectrometers found: " + specs.length);
        for (int i = 0; i < specs.length; ++i) {
            System.out.println("Checking device: " + specs[i].getName());
            if (specs[i] instanceof IrradianceCalibrationFactor) {
                IrradianceCalibrationFactor irradCalFeature = (IrradianceCalibrationFactor)((Object)specs[i]);
                if (irradCalFeature.hasCollectionArea()) {
                    System.out.println("Device " + specs[i].getName() + " appears to have a stored collection area.");
                    double collectionArea = 1.0;
                    boolean collectionAreaExists = false;
                    try {
                        collectionArea = irradCalFeature.getCollectionArea();
                        collectionAreaExists = true;
                        System.out.println("Collection area: " + collectionArea);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.out.println("Failed to read collection area.");
                    }
                    System.out.println("Attempting to set collection area to 0.25");
                    try {
                        irradCalFeature.setCollectionArea(0.25);
                        System.out.println("Collection area reset has been attempted.");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.out.println("Failed to write collection area.");
                    }
                    try {
                        double temp = irradCalFeature.getCollectionArea();
                        System.out.println("Collection area: " + temp);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.out.println("Failed to read collection area.");
                    }
                    if (collectionAreaExists) {
                        System.out.println("Attempting to restore collection area.");
                        try {
                            irradCalFeature.setCollectionArea(collectionArea);
                            System.out.println("Collection area reset has been attempted.");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            System.out.println("Failed to write collection area.");
                        }
                        try {
                            double temp = irradCalFeature.getCollectionArea();
                            System.out.println("Collection area: " + temp);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            System.out.println("Failed to read collection area.");
                        }
                    }
                } else {
                    System.out.println("Device has no collection area stored.");
                }
                System.out.println("Attempting to get calibration...");
                double[] calibration = null;
                try {
                    calibration = irradCalFeature.getIrradianceCalibrationFactors();
                    for (int c = 0; c < calibration.length; ++c) {
                        System.out.println(c + ": " + calibration[c]);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.out.println("Failed to read calibration.");
                }
                System.out.println("Attempting to write new calibration.");
                double[] tempcal = new double[specs[i].getNumberOfPixels()];
                for (int j = 0; j < tempcal.length; ++j) {
                    tempcal[j] = 0.25 * (double)j;
                }
                try {
                    irradCalFeature.setIrradianceCalibrationFactors(tempcal);
                    System.out.println("Finished writing new calibration.");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.out.println("Failed to write new calibration.");
                }
                System.out.println("Attempting to get calibration...");
                double[] cal = null;
                try {
                    cal = irradCalFeature.getIrradianceCalibrationFactors();
                    for (int c = 0; c < cal.length; ++c) {
                        System.out.println(c + ": " + cal[c]);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.out.println("Failed to read calibration.");
                }
                if (null != calibration) {
                    System.out.println("Attempting to restore original calibration.");
                    try {
                        irradCalFeature.setIrradianceCalibrationFactors(calibration);
                        System.out.println("Finished restoring calibration.");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.out.println("Failed to restore calibration.");
                    }
                }
                System.out.println("Attempting to get calibration...");
                try {
                    cal = irradCalFeature.getIrradianceCalibrationFactors();
                    for (int c = 0; c < cal.length; ++c) {
                        System.out.println(c + ": " + cal[c]);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.out.println("Failed to read calibration.");
                }
            }
            System.out.println("Done with device " + specs[i].getName());
        }
    }
}

