/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.tests;

import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.OmniSpectrum;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerFactory;
import com.oceanoptics.spectralprocessing.SpectralProcessor;
import java.io.IOException;

public class PollingTest {
    private Spectrometer[] spectrometers;
    private SpectrometerChannel[] channels;
    private SpectralProcessor[] processors;
    private int totalNumberOfChannels;
    private static String __extern__ = "__extern__\n<init>,()V\nmain,([Ljava/lang/String;)V\n";

    public PollingTest() {
        try {
            Spectrometer spectrometer;
            int i;
            this.spectrometers = SpectrometerFactory.getAllSpectrometers();
            if (this.spectrometers == null || this.spectrometers.length == 0) {
                System.out.println("No spectrometers found.");
                return;
            }
            for (i = 0; i < this.spectrometers.length; ++i) {
                spectrometer = this.spectrometers[i];
                System.out.println(spectrometer);
                SpectrometerPlugIn[] plugIns = null;
                if (spectrometer instanceof PlugInProvider) {
                    PlugInProvider pip = (PlugInProvider)((Object)spectrometer);
                    plugIns = pip.getPlugIns();
                }
                if (plugIns != null) {
                    System.out.print("\n" + plugIns.length + " plugin(s):");
                    for (int j = 0; j < plugIns.length; ++j) {
                        System.out.println(" " + plugIns[j]);
                    }
                    System.out.println("");
                }
                this.totalNumberOfChannels += spectrometer.getNumberOfChannels();
                System.out.println("________________________________________________________________________________\n");
                System.out.flush();
            }
            this.channels = new SpectrometerChannel[this.totalNumberOfChannels];
            this.processors = new SpectralProcessor[this.totalNumberOfChannels];
            this.totalNumberOfChannels = 0;
            for (i = 0; i < this.spectrometers.length; ++i) {
                spectrometer = this.spectrometers[i];
                SpectrometerChannel[] spectrometerChannels = spectrometer.getChannels();
                for (int j = 0; j < this.totalNumberOfChannels; ++j) {
                    if (spectrometerChannels[j] == null) continue;
                    this.channels[this.totalNumberOfChannels] = spectrometerChannels[j];
                    this.processors[this.totalNumberOfChannels] = new SpectralProcessor(spectrometerChannels[j], false);
                    ++this.totalNumberOfChannels;
                }
            }
            for (int i2 = 0; i2 < this.channels.length; ++i2) {
                SpectrometerChannel channel = this.channels[i2];
                SpectralProcessor processor = this.processors[i2];
                if (channel == null) continue;
                processor.setScansToAverage(1);
                processor.setCorrectForElectricalDark(false);
                processor.setCorrectForDetectorNonlinearity(false);
                processor.setCorrectForStrayLight(false);
                processor.setSmoothingWindowSize(1);
                int p = channel.getNumberOfPixels();
                int d = channel.getNumberOfDarkPixels();
                Spectrum spectrum = new Spectrum(p, d);
                OmniSpectrum os = new OmniSpectrum(channel.getSpectrometerChannelInfo());
                os = processor.getOmniSpectrum();
                System.out.println(os.toString());
                for (int j = 0; j < 5; ++j) {
                    int x;
                    spectrum = processor.getSpectrum(spectrum);
                    double[] pixels = spectrum.getSpectrum();
                    System.out.println("\nScan " + (j + 1));
                    for (x = 0; x < pixels.length; ++x) {
                        System.out.print(pixels[x] + " ");
                    }
                    System.out.println("\nPixels: " + x);
                }
            }
        }
        catch (IOException e) {
            System.out.println("An Exception occurred");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        PollingTest t = new PollingTest();
        System.out.println("\nEnd.");
    }
}

