/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.tests;

import com.oceanoptics.omnidriver.api.wrapper.Wrapper;
import com.oceanoptics.omnidriver.spectrometer.Detector;
import com.oceanoptics.omnidriver.spectrometer.sts.STSBench;

public class STSBenchTest {
    private static String __extern__ = "__extern__\n<init>,()V\nmain,([Ljava/lang/String;)V\n";

    public static void main(String[] args) {
        Wrapper wrapper = new Wrapper();
        wrapper.insertKey("wpT379hLw");
        int specCount = wrapper.openAllSpectrometers();
        for (int i = 0; i < specCount; ++i) {
            STSBench bench = wrapper.getSTSBench(i);
            if (null == bench) continue;
            Detector detector = wrapper.getDetector(i, 0);
            System.out.println("Reading existing bench info...");
            String fiber = bench.getFiberDiameter();
            String filter = bench.getFilterWavelength();
            String grating = bench.getGrating();
            String slit = bench.getSlitSize();
            String id = bench.getID();
            String coating = detector.getArrayCoatingMfg();
            String serial = detector.getSerialNumber();
            System.out.println("Bench info:");
            System.out.println("serial number: " + serial);
            System.out.println("ID: " + id);
            System.out.println("slit: " + slit);
            System.out.println("grating: " + grating);
            System.out.println("filter: " + filter);
            System.out.println("fiber: " + fiber);
            bench.setFiberDiameter("1000");
            bench.setSlitSize("100");
            bench.setFilterWavelength("350nm");
            bench.setGrating("STS-NIR");
            bench.setID("STS-GEN1-SN6");
            detector.setArrayCoatingMfg("Uncoated");
            detector.setSerialNumber("SN6");
            boolean success = wrapper.saveSTSConfiguration(i);
            if (!success) {
                System.out.println("Failed to save STS parameters.");
                continue;
            }
            System.out.println("New parameters were successfully saved.");
        }
        wrapper.closeAllSpectrometers();
    }
}

