XRANGE=25
LMARGIN=15 
SIZEX=1  
SIZEY=0.20 
OR1=0.68 
OR2=0.48 
OR3=0.28 
OR4=0.08

#final without plasma
GPf=set datafile separator ';';set xrange [0:$(XRANGE)];set tmargin 0;set bmargin 1;set lmargin $(LMARGIN);set format y '%3.1f';set rmargin 3;set multiplot;set title 'Golem shot No:`cat ../../../ShotNo`';set size $(SIZEX),$(SIZEY); set origin 0,$(OR1);set ylabel 'U_{loop} [V]';unset key;unset xtics;set style data dots; set yrange [-1:30];plot 'Uloop_dp.csv' u 1:2;\
unset title; set origin 0,$(OR2);set ylabel 'B_t [T]';set format y '%3.2f';unset key;unset xtics;set yrange [-0.01:*];plot 'Btoroidal_dp.csv';\
unset title; set origin 0,$(OR3);set ylabel 'I_{ch} [kA]';set format y '%3.1f';unset key;unset xtics;set yrange [*:*];plot 'Irogowski_dp.csv' u 1:(\$$2/1000);\
unset title; set origin 0,$(OR4);set ylabel 'Photod [a.u.]';set format y '%3.3f';unset key;set xtics ('5' 5,'10' 10, '15' 15, '20' 20, '25' 25, '30' 30);set xlabel 'Time [ms]';set yrange [-0.005:*];plot 'Photod_dp.csv','PhotodHalfa_dp.csv';\

#final with plasma
GPfPlasma=set datafile separator ';';set xrange [0:$(XRANGE)];set tmargin 0;set bmargin 1;set lmargin $(LMARGIN);set format y '%3.1f';set rmargin 3;set multiplot;set title 'Golem shot No:`cat ../../../ShotNo` ,Delta T=`cat PlasmaTimeLength` ms, Q_{tot}=`cat PlasmaTotalCharge` C, T_e=`cat ElectronTemperature` eV, Q_{edge}=`cat Qedge`, Tau_e=`cat ElectronConfinementTimeFirstApprox` ms,';set size $(SIZEX),$(SIZEY);set origin 0,$(OR1);set ylabel 'U_{loop} [V]';unset key;unset xtics;set style data dots; set yrange [0:30];plot 'Uloop_dp.csv' u 1:2;\
unset title; set origin 0,$(OR2);set ylabel 'B_t [T]';set format y '%3.2f';unset key;unset xtics;set yrange [-0.01:*];plot 'Btoroidal_dp.csv';\
unset title; set origin 0,$(OR3);set ylabel 'I_{p} [kA]';set format y '%3.1f';unset key;unset xtics;set yrange [-1:8];plot 'Iplasma_dp.csv' u 1:(\$$2/1000) ;set parametric; set trange [1:4]; replot `cat PlasmaStart`,t;replot `cat PlasmaEnd`,t;\
unset title; set origin 0,$(OR4);set ylabel 'Ir,IHa [a.u.]';set format y '%3.3f';unset key;set xtics ('5' 5,'10' 10, '15' 15, '20' 20, '25' 25, '30' 30);set xlabel 'Time [ms]';set yrange [-0.005:*];plot 'Photod_dp.csv' lt rgb 'orange' title 'hhhh','PhotodHalfa_dp.csv' title 'jkjkj' lt rgb 'red' ; 


#DynStabil 
# GPfPlasma=set datafile separator ';';set xrange [0:$(XRANGE)];set tmargin 0;set bmargin 1;set lmargin $(LMARGIN);set format y '%3.1f';set rmargin 3;set multiplot;set title 'Golem shot No:`cat ../ShotNo`\n,Delta T=`cat PlasmaTimeLength` ms, Q_{tot}=`cat PlasmaTotalCharge` C, T_e=`cat ElectronTemperature` eV, Qedge=`cat Qedge`, Tau_e=`cat ElectronConfinementTimeFirstApprox` ms,';set size $(SIZEX),$(SIZEY);set origin 0,$(OR1);set ylabel 'U_{loop} [V]';unset key;unset xtics;set style data dots; set yrange [-5:30];plot 'Uloop_dp.csv' u 1:2;\
# unset title; set origin 0,$(OR2);set ylabel 'B_t [T]';set format y '%3.2f';unset key;unset xtics;set yrange [-0.05:*];plot 'Btoroidal_dp.csv';\
# unset title; set origin 0,$(OR3);set ylabel 'I_{p} [kA]';set format y '%3.1f';unset key;unset xtics;set yrange [*:*];plot 'Iplasma_dp.csv' u 1:(\$$2/1000) ;set parametric; set trange [1:4]; replot `cat PlasmaStart`,t;replot `cat PlasmaEnd`,t;\
# unset title; set origin 0,$(OR4);set ylabel 'I_{dyn} [a.u.]';set format y '%3.2f';unset key;set xtics ('5' 5,'10' 10, '15' 15, '20' 20, '25' 25, '30' 30);set xlabel 'Time [ms]';set yrange [*:*];plot 'Photod_dp.csv';\


#final+ plasma + crop
GPfPlasmaZoom=set datafile separator ';';set xrange [`cat PlasmaStartAdvanced`:`cat PlasmaEndDelayed`];set tmargin 0;set bmargin 1;set lmargin $(LMARGIN);set format y '%3.1f';set rmargin 3;set multiplot;set title 'Golem shot No:`cat ../../../ShotNo`';set size $(SIZEX),$(SIZEY);set origin 0,$(OR1);set ylabel 'U_{loop} [V]';unset key;unset xtics;set style data lines; set yrange [0:30];plot 'Uloop_dp.csv' u 1:2   lt rgb 'red';\
unset title; set origin 0,$(OR2);set ylabel 'B_t [T]';set format y '%3.2f';unset key;unset xtics;set yrange [-0.01:*];plot 'Btoroidal_dp.csv'   lt rgb 'red';\
unset title; set origin 0,$(OR3);set ylabel 'I_{p} [kA]';set format y '%3.1f';unset key;unset xtics;set yrange [*:*];plot 'Iplasma_dp.csv' u 1:(\$$2/1000)   lt rgb 'red';\
unset title; set origin 0,$(OR4);set ylabel 'Ir,IHa [a.u.]';set format y '%3.3f';unset key;set xtics;set xlabel 'Time [ms]';set yrange [-0.005:*];plot 'Photod_dp.csv'  lt rgb 'orange','PhotodHalfa_dp.csv'  lt rgb 'red';\


#integrated
GPi=set datafile separator ';';set xrange [0:$(XRANGE)];set tmargin 0;set bmargin 1;set lmargin $(LMARGIN);set format y '%3.1f';set rmargin 3;set multiplot;set title 'Golem shot No:`cat ../../../ShotNo`';set size $(SIZEX),$(SIZEY);set origin 0,$(OR1);set ylabel 'U_{loop} [V]';unset key;unset xtics;set style data dots; set yrange [0:30];plot 'Uloop_dp.csv' u 1:2;\
unset title; set origin 0,$(OR2);set ylabel 'B_t [T]';set format y '%3.2f';unset key;unset xtics;set yrange [-0.01:*];plot 'Btoroidal_dp.csv';\
unset title; set origin 0,$(OR3);set ylabel 'I_{p+ch} [A]';set format y '%3.1f';unset key;unset xtics;set yrange [*:*];plot 'Irogowski_dp.csv' u 1:(\$$2/1000);\
unset title; set origin 0,$(OR4);set ylabel 'PhotoD [a.u.]';set format y '%3.3f';unset key;set xtics ('5' 5,'10' 10, '15' 15, '20' 20, '25' 25, '30' 30);set xlabel 'Time [ms]';set yrange [-0.005:*];plot 'Photod_dp.csv','PhotodHalfa_dp.csv';\

#raw
GPb=set xrange [0:3000];set tmargin 0;set bmargin 1;set lmargin $(LMARGIN);set rmargin 3;set multiplot;set size $(SIZEX),$(SIZEY);set origin 0,$(OR1);set ylabel 'U_{loop} [DAS V]';$(LAB1);unset key;unset xtics;set style data dots; set yrange [-5:*];plot 'usbscopes' using 0:1;\
set origin 0,$(OR2);$(LAB2)set ylabel 'dB_t/dt [DAS V]';unset key;set yrange [-1:1];unset xtics;plot 'usbscopes' using 0:2;\
set origin 0,$(OR3);$(LAB2)set ylabel 'dI_{p+ch}/dt [DAS V]';unset key;unset xtics;set yrange [-1:*] ;plot 'usbscopes' using 0:3;\
set origin 0,$(OR4);$(LAB3)set ylabel 'PhotoD [DAS V]';unset key;set xtics ('5' 500,'10' 1000, '15' 1500, '20' 2000, '25' 2500, '30' 3000);set xlabel 'Time [ms]';set yrange [*:*];plot 'usbscopes' using 0:4,'usbscopes' using 0:5;\

#preview
GPic=set datafile separator ';';set xrange [0:$(XRANGE)];set xtics ('5' 5,'10' 10, '15' 15, '20' 20, '25' 25, '30' 30);unset xlabel ;set tmargin 0;set bmargin 0;set lmargin 15;set rmargin 0;set size 2,0.4;set format y '%3.1f';set multiplot;set size 1,0.3;set origin 0,0.08;set ylabel 'U_{loop} [V]';unset key;set style data dots; set yrange [0:30];plot 'Uloop_dp.csv' u 1:2 w points pt 7 ps 0.5;\
unset title; set origin 1,0.08;set ylabel 'I_{p+ch} [kA]';unset key;set yrange [-1:20];plot 'Irogowski_dp.csv' u 1:(\$$2/1000) w points pt 7 ps 0.5;\





all:
	make -f makefile.gp x11 LMARGIN=15 SIZEX=1  SIZEY=0.20 OR1=0.68 OR2=0.48 OR3=0.28 OR4=0.08 
	make -f makefile.gp pres LMARGIN=15 SIZEX=1.0  SIZEY=0.20 OR1=0.68 OR2=0.48 OR3=0.28 OR4=0.08
	make -f makefile.gp icona 
# 	make -f makefile.gp print LMARGIN=5 SIZEX=0.8  SIZEY=0.15 OR1=0.85 OR2=0.7 OR3=0.55 OR4=0.4

x11full:
	if [ -f PlasmaStart -a -f PlasmaEnd ]; then\
		echo "$(GPfPlasma)"|gnuplot -persist;\
	else\
		echo "$(GPf)"|gnuplot -persist;\
	fi   
	#echo "plot 'usbscopes' u 0:1 with lines "|gnuplot -persist
	#echo "set datafile separator ';';plot 'Iplasma_dp.csv' using 1:(\$$2/1000) with lines, 'Uloop_dp.csv' u 1:2 with lines"| gnuplot -persist

x11:
	if [ -f PlasmaStart -a -f PlasmaEnd ]; then\
		echo "set terminal X11;$(GPfPlasma)"|gnuplot -persist;\
	else\
		echo "set terminal X11;$(GPf)"|gnuplot -persist;\
	fi   
	#echo "plot 'usbscopes' u 0:1 with lines "|gnuplot -persist
	#echo "set datafile separator ';';plot 'Iplasma_dp.csv' using 1:(\$$2/1000) with lines, 'Uloop_dp.csv' u 1:2 with lines"| gnuplot -persist


print:
	echo "set terminal postscript portrait enhanced;$(GPf)"|gnuplot > graphprint.ps;\
 	convert graphprint.ps graphprint.png

pres:
	if [ -f PlasmaStart -a -f PlasmaEnd ]; then\
	   echo "set terminal postscript  enhanced;$(GPfPlasmaZoom)"|gnuplot > graphpres.ps;\
	   echo "set terminal postscript  enhanced;$(GPfPlasma)"|gnuplot > graphpresfull.ps;\
	else\
	   echo "set terminal postscript  enhanced;$(GPf)"|gnuplot > graphpres.ps;\
	   echo "set terminal postscript  enhanced;$(GPf)"|gnuplot > graphpresfull.ps;\
	fi   
	convert -rotate 90 graphpres.ps graphpres.png
	convert -rotate 90 graphpresfull.ps graphpresfull.png

	echo "set terminal postscript  enhanced;$(GPi)"|gnuplot > graphpresi.ps;\
	convert -rotate 90 graphpresi.ps graphpresi.png
	echo "set terminal postscript  enhanced;$(GPb)"|gnuplot > graphpresb.ps;\
	convert -rotate 90 graphpresb.ps graphpresb.png

icona:
	echo "set terminal postscript eps enhanced;$(GPic)"|gnuplot > graphic.eps;
	convert -size 500 graphic.eps graphic.png
	#echo "set terminal X11;$(GPic)"|gnuplot  -persist



#HELP
#Specialni symboly pro ps
#http://t16web.lanl.gov/Kawano/gnuplot/label-e.html#4.1

test:
	echo "set terminal X11;plot 'usbscopes' using 0:2;"|gnuplot -persist

pool:
	make -f makefile.gp x11 LMARGIN=15 SIZEX=1  SIZEY=0.25 OR1=0.75 OR2=0.5 OR3=0.25 OR4=0





















