#!/bin/perl
#Constants
$Pi=3.141592653;
$Mu0=4*$Pi*1e-7;
$kB=1.3806503e-23;
$eV=1.60217646e-19;
$RoomTemperature=300;#[K]


#Basics
$MajorRadius=0.4; 
$MinorRadius=0.1;
$LimiterPosition=0.085;
$PlasmaVolume=$Pi*$LimiterPosition^2*2*$Pi*$MajorRadius;
$ToroidalMagneticFieldCoilInductance=2.8e-3;#[H] PhD. thesis J. Brotankova

#Energetics (15.09.10):
$TororoidalMagneticFieldCapacitor=51*450e-6;#[F]
$TororoidalMagneticFieldCapacitorValue=23;#[mF]
$BreakDownElectricFieldCapacitor=8*450e-6;#[F]
$BreakDownElectricFieldCapacitorValue=3.6;#[mF]
$CurrentDriveElectricFieldCapacitor=25*450e-6;#[F]
$CurrentDriveElectricFieldCapacitorValue=11.3;#[mF]
$StabilizationCapacitor=6*450e-6;#[F]
$StabilizationCapacitorValue=2.7;#[mF]

$TororoidalMagneticFieldTrigger = 5;#[ms]

#DAS calibration
$LineCount=40000;  #scopes DAS file line count
$TriggerLine=3500; #plasma discharge is triggered at data row
$DeltaT=1e-3;     #[ms] DAS time
$DeltaTs=1e-6;     #[s] DAS time
$Bt_calibration=70.42; #[T/Vs] 0311 podle Tomase Markovice
$RogowskiCalibration=5.3e6; #[A/Vs] 03/2010, CASTOR calibration (Mr. F.Zacek), 10 us vzorkovani, p. Zacek uvadi 5.3 e6 A/Vs
$UloopCalibration=3.75;
$ChamberResistance=7.44e-3;#9.24e-3; #[Ohm] 
$ChamberInduktance=0.60e-6; #[H] 

#PlasmaDetect
$PlCurrentRise=500; #[A]
$PlCurrentIncrTime=1e-3; 
$PlCurrentSurv=1e-3;

#Others
$shotdir='/mnt/data2/srv/www/svoboda/golem/operation/shots'
