package require Tk
 set ::pi 3.1415927 ;# Good enough accuracy for gfx...

 # Create a meter 'enabled' canvas
 proc makeMeter {} {
     global meter limit angleM angleL
     canvas .c -width 200 -height 110 -borderwidth 2 -relief sunken -bg white
         set meter [.c create line 100 100 10 100 -fill red -width 3 -arrow last]
         set limit [.c create line 100 100 10 100 -fill black -width 3 -arrow last]
         set angleM 0
         set angleL 0
         .c lower $meter
         .c lower $limit
         updateMeterLine .c 0.2 0.2 

     .c create arc 10 10 190 190 -extent 108 -start 36 -style arc -outline blue
     return .c
 }

 # Draw a meter line (and recurse for lighter ones...)
 proc updateMeterLine {w m l} {
     global meter limit pi
     #set meter	
     set x [expr {100.0 - 90.0*cos($m * $pi)}]
     set y [expr {100.0 - 90.0*sin($m * $pi)}]
     $w coords $meter 100 100 $x $y
     #set limit	
     set x [expr {100.0 - 90.0*cos($l * $pi)}]
     set y [expr {100.0 - 90.0*sin($l * $pi)}]
     $w coords $limit 100 100 $x $y

 }

 # Convert variable to angle on trace
 proc updateMeter { Meter Limit } {
# global Meter Limit
     set min [.s cget -from]
     set max [.s cget -to]
     set posM [expr {($Meter - $min) / ($max - $min)}]
     set min [.s cget -from]
     set max [.s cget -to]
     set posL [expr {($Limit - $min) / ($max - $min)}]

     updateMeterLine .c [expr {$posM*0.6+0.2}] [expr {$posL*0.6+0.2}] 
 }






